#include "membertype.h"
#include "member_cache.h"

using namespace aka2;

bool any_member::equals(const void *lhs, const void *rhs) const {
  const_member_cache  lhscache(lhs, *op_, *mgetter_);
  const_member_cache  rhscache(rhs, *op_, *mgetter_);
  lhscache.prepare();
  rhscache.prepare();
  return op_->equals(lhscache.value(), rhscache.value());
}


void any_member::copy(void *dest, const void *src) const {
  member_cache destcache(dest, *op_, *mgetter_);
  const_member_cache srccache(dest, *op_, *mgetter_);
  destcache.prepare(false);
  srccache.prepare();
  op_->copy(destcache.get_node().ptr(), srccache.get_node().ptr());
  destcache.flush();
}

void named_member::set_member_to_default(void *e) const {
  member_cache cache(e, *op_, getter());
  cache.prepare(false);
  set_default(cache.value());
  cache.flush();
}

bool attribute_type::is_attribute_default(const void *elm) const {
  if (!is_default_specified()) // @default
    return false;

  const_member_cache cache(elm, *op_, getter());
  cache.prepare();
  return is_default(cache.value());
}

