/* -*- c++ -*- */
#ifndef AKAXISO_MUTEX_H__
#define AKAXISO_MUTEX_H__

#include <akaxiso/configuration.h>

#ifdef USE_PTHREADS

#include <pthread.h>

namespace aka2 {

  class mutex {
  public:
    mutex();
    ~mutex();
    void lock();
    void unlock();
  private:
    pthread_mutex_t mutex_;
  };

}

#endif // USE_PTHREADS



/** Mutex for WIN32 */
#ifdef _WIN32

#include <winbase.h>

namespace aka2 {

  class mutex {
  public:
    mutex();
    ~mutex();
    void lock();
    void unlock();
  private:
    CRITICAL_SECTION critical_section_;
  };

}  

#endif

#endif
