// -*- c++ -*-
#ifndef AKAXISO_CHOICE_HANDLER_H__
#define AKAXISO_CHOICE_HANDLER_H__

#include <akaxiso/parser/handler.h>

namespace aka2 {
  
  class choice_handler : public handler {
  public:
    choice_handler(const qname &tagname, void *cho, int depth,
		   const choice_op &cop, const occurrence &occ,
		   parser_context &context);
    virtual ~choice_handler();
    virtual parse_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual parse_result end_element(const qname &tagname);
    virtual parse_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const std::string &entity);
    
    virtual node get_node();
    virtual void receive_child(const node &child);
    
    virtual bool can_skip();
    virtual void abort();
  private:
    parse_result parse_element(const attribute_values &attrs);
    parse_result find_particle(const qname &tagname, const attribute_values &attrs,
			       itemtypes::const_iterator &found);
    void *cho_;
    void *e_;
    const choice_op &cop_;
    const occurrence &occurrence_;
    int count_;
    const itemtypes &itypes_;
    itemtypes::const_iterator current_;
    itemtypes::const_iterator searching_;
  };

}

#endif

