#include "platform.h"
#include "exception.h"

#if defined(__linux__) && !defined(__BORLANDC__)

#include <ctype.h>

int stricmp(const char *lhs, const char *rhs) {
  while ((*lhs != 0) || (*rhs != 0)) {
    int slhs = tolower(*lhs);
    int srhs = tolower(*rhs);
    if (slhs != srhs)
      return (slhs - srhs);
    ++lhs; ++rhs;
  }
  return 0;
}

#endif /* __linux__ && !__BORLANDC__ */


#ifdef _MSC_VER

#include <iostream>

std::istream &operator >>(std::istream &istm, _int64 &value) {
  char buf[256];
  istm.getline(buf, sizeof(buf));
  if (sscanf(buf, "%I64d", &value) != 1)
    throw aka2::internal_error();
  return istm;
}

std::istream &operator >>(std::istream &istm, unsigned _int64 &value) {
  char buf[256];
  istm.getline(buf, sizeof(buf));
  if (sscanf(buf, "%I64u", &value) != 1)
    throw aka2::internal_error();
  return istm;
}

#endif /* _MSC_VER */
