#include "ustring.h"

#if defined(IMPLEMENT_CHAR_TRAITS)

using namespace aka2;
void std::char_traits<aka2::uchar_t>::assign(char_type& __c1, const char_type& __c2)
  { __c1 = __c2; }

bool std::char_traits<uchar_t>::eq(const char_type& __c1, const char_type& __c2)
  { return __c1 == __c2; }

bool std::char_traits<uchar_t>::lt(const char_type& __c1, const char_type& __c2)
  { return __c1 < __c2; }

int std::char_traits<uchar_t>::compare(const char_type* __s1, const char_type* __s2, size_t __n) { 
  
  for (size_t i = 0; i < __n; ++i) {
    if (*__s1 != *__s2)
      return *__s1 - *__s2;
    ++__s1; ++__s2;
  }
  return 0;
}


size_t std::char_traits<uchar_t>::length(const char_type* __s)  { 
  const char_type *__e = __s;
  while (*__e != 0x0000)
    ++__e;
  return __e - __s;
}

const uchar_t* std::char_traits<uchar_t>::find(const char_type* __s, 
					   size_t __n, 
					   const char_type& __a) { 
  const char_type* __i = __s;
  const char_type* __e = __s + __n;
  while ((__i < __e) && (*__i != __a))
    ++__i;
  return __i == __e ? 0 : __i;
}

uchar_t* 
  std::char_traits<uchar_t>::move(char_type* __s1, const char_type* __s2, size_t __n) { 
  memmove(__s1, __s2, __n * sizeof(char_type));
  return __s1;
}

uchar_t* 
  std::char_traits<uchar_t>::copy(char_type* __s1, const char_type* __s2, size_t __n) { 
  memcpy(__s1, __s2, __n * sizeof(char_type)); 
   return __s1;
}

uchar_t* std::char_traits<uchar_t>::assign(char_type* __s, size_t __n, char_type __a)  { 
  for (char_type* __i = __s; __i < __s + __n; ++__i)
    *__i = __a;
  return  __s;
}

uchar_t std::char_traits<uchar_t>::to_char_type(const int_type& __c) { 
  return char_type(__c); 
}

unsigned long 
  std::char_traits<uchar_t>::to_int_type(const char_type& __c) { return int_type(__c); }

bool 
  std::char_traits<uchar_t>::eq_int_type(const int_type& __c1, const int_type& __c2)
  { return __c1 == __c2; }

unsigned long 
  std::char_traits<uchar_t>::eof() { return static_cast<int_type>(0xffffffffu); }

unsigned long  
  std::char_traits<uchar_t>::not_eof(const int_type& __c)
  { return eq_int_type(__c, eof()) ? 0 : __c; }

#endif
