/* -*- c++ -*- */
#ifndef EXCEPTION_H__
#define EXCEPTION_H__

#include <sstream>

namespace osixaka {

  class fatal_error : public std::exception {
  public:
    fatal_error(const char *file, const unsigned long line, const char *msg) {
      std::ostringstream ostm;
      ostm << file << ':' << line << ':' << msg;
      msg_ = ostm.rdbuf()->str();
    }
    virtual ~fatal_error() throw() {}
    virtual const char *what() const throw() { return msg_.c_str(); } 
  private:
    std::string msg_;
  };

}

#endif
