/* -*- c++ -*- */
#include <iostream>
#include <iomanip>
#include <fstream>
#include <stdlib.h>

#include "ltg.h"
#include "element.h"


bool test_parse_ok(const ltg::file &f) {
  aka::xml_parser parser;
  bool test = true;
  try {
    parser.parse_file(f.get_filepath());
  }
  catch ( ... ) {
    test = false;
  }
  return test;
}

bool test_parse_ng(const ltg::file &f) {
  return false;
}


int main(int argc, char* argv[]){

  aka::initialize();
  // Initialize XML-Schema Document Classes.
  ltg::instantiate_xiso();
  xs::instantiate_xiso();

  int total = 0;
  int ok = 0;

  aka::xml_parser parser;
  aka::document ltgdoc = parser.parse_file(argv[1]);
  ltg::root *root = aka::root_cast<ltg::root>(ltgdoc);
  const ltg::tests &tests = root->tests_;

  for (ltg::tests::const_iterator testit = tests.begin();
       testit != tests.end(); ++testit) {
    const ltg::files &fs = testit->files_;
    for (ltg::files::const_iterator fileit = fs.begin();
	 fileit != fs.end(); ++fileit) {
      bool res;
      bool done = false;

      if (fileit->validity_ && (fileit->role_ == "schema")) {
	res = test_parse_ok(*fileit);
	done = true;
      }
//       else if (!fileit->validity_ && (fileit->role_ == "schema")) {
// 	res = test_parse_ng(*fileit);
// 	done = true;
//       }

      if (done) {
	if (res) {
	  ++ok;
	  std::cout << '.' << std::flush;
	}
	else {
	  std::cout << std::endl
		    << "Failure:" << fileit->get_filepath() << std::endl;
	} 
	++total;
      }
    }
  }

  std::cout << std::endl
	    << argv[1] << std::endl
	    << "total: " << total 
	    << "  ok: " << ok << "  fail: " << total - ok << std::endl;

  // Uninitializers.
  aka::uninitialize();
  return 0;
}
