#include <akaxiso/akaxiso.h>
#include <iostream>

/** 
 *  element.h generated by osixaka2 has decarations 
 *  for element classes and serialization functions.
 */
#include "element.h"

int main(int argc, char* argv[]){
  
  // initialize akaxiso library.
  aka::initialize();
  // instantiate xiso::leaf classes to allow xs:schema to be deserialized.
  xs::instantiate_xiso();

  // parsing from stdin.
  aka::document doc;
  try {
    doc = aka::parse(std::cin);
  }
  catch (const aka::parse_error &e) {
    std::cerr << e.what() << std::endl;
    std::cerr << "Parse error detected.  Abort immediately." << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Unhandled parse error detected.  Abort immediatedly." << std::endl;
    exit(1);
  }

  // Check document tagname.
  assert(aka::document_of(doc, "xs:schema")); 

  // Get root node.
  // Obtained root node(xs:schema) is owned by doc by its shared pointer member.
  xs::schema *schema = aka::root_cast<xs::schema>(doc);
  /**
   *  If you want to get ownership of root node instance, use aka::adopt_node<>() 
   * as shown in the following line, and you have to delete root node by yourself.
   * xs::schema *schema = aka::adopt_root<xs::schema>(doc);
  */

  // serialization of schema instance to std::cout.
  serialize(*schema, std::cout);

  // Uninitialize akaxiso to release global resources.
  aka::uninitialize();

  return 0;
}
