/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.audio.word;

import java.io.File;
import org.jpn.xucker.commons.audio.FileAudioPlayer;
import org.jpn.xucker.commons.audio.JavaSoundAudioPlayer;
import org.jpn.xucker.commons.audio.word.AbstractWordPlayer;
import org.jpn.xucker.commons.audio.word.LocalFilePlainWordFinder;
import org.jpn.xucker.commons.audio.word.LocalFileWordFinder;

public class LocalFileWordPlayer
extends AbstractWordPlayer {
    private String baseDirectoryPath;
    private FileAudioPlayer player;
    LocalFileWordFinder finder;
    public static final int BOTH = 0;
    public static final int ALPHABET = 1;
    public static final int PLAIN = 2;
    private int mode;

    public LocalFileWordPlayer(String path) {
        this.baseDirectoryPath = path;
        this.player = new JavaSoundAudioPlayer();
        this.finder = new LocalFilePlainWordFinder();
    }

    public LocalFileWordPlayer(String path, FileAudioPlayer player, LocalFileWordFinder finder) {
        this.baseDirectoryPath = path;
        this.player = player;
        this.finder = finder;
    }

    public FileAudioPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(FileAudioPlayer player) {
        this.player = player;
    }

    public void play(String word) {
        File file = this.getWordFile(word);
        if (file.exists() && this.player != null) {
            this.player.play(file);
        }
    }

    private File getWordFile(String word) {
        return this.finder.getFile(this.baseDirectoryPath, word);
    }

    public boolean exist(String word) {
        File file = this.getWordFile(word);
        return file != null && file.exists();
    }

    public void setBaseDirectoryPath(String path) {
        this.baseDirectoryPath = path;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }
}

