/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.io.File;
import java.io.Serializable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.ProgramImageDescriptor;

public final class EditorDescriptor
implements IEditorDescriptor,
Serializable,
IPluginContribution {
    private static final String ATT_EDITOR_CONTRIBUTOR = "contributorClass";
    public static final int OPEN_INTERNAL = 1;
    public static final int OPEN_INPLACE = 2;
    public static final int OPEN_EXTERNAL = 4;
    private String editorName;
    private String imageFilename;
    private transient ImageDescriptor imageDesc;
    private boolean testImage = true;
    private String className;
    private String launcherName;
    private String fileName;
    private String id;
    private Program program;
    private String pluginIdentifier;
    private int openMode = 0;
    private transient IConfigurationElement configurationElement;

    EditorDescriptor() {
    }

    public static EditorDescriptor createForProgram(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException();
        }
        EditorDescriptor editor = new EditorDescriptor();
        editor.setFileName(filename);
        editor.setID(filename);
        editor.setOpenMode(4);
        int start = filename.lastIndexOf(File.separator);
        String name = start != -1 ? filename.substring(start + 1) : filename;
        int end = name.lastIndexOf(46);
        if (end != -1) {
            name = name.substring(0, end);
        }
        editor.setName(name);
        ProgramImageDescriptor imageDescriptor = new ProgramImageDescriptor(filename, 0);
        editor.setImageDescriptor(imageDescriptor);
        return editor;
    }

    private static Program findProgram(String programName) {
        Program[] programs = Program.getPrograms();
        int i = 0;
        while (i < programs.length) {
            if (programs[i].getName().equals(programName)) {
                return programs[i];
            }
            ++i;
        }
        return null;
    }

    public IEditorActionBarContributor createActionBarContributor() {
        if (this.configurationElement == null) {
            return null;
        }
        String className = this.configurationElement.getAttribute(ATT_EDITOR_CONTRIBUTOR);
        if (className == null) {
            return null;
        }
        IEditorActionBarContributor contributor = null;
        try {
            contributor = (IEditorActionBarContributor)WorkbenchPlugin.createExtension(this.configurationElement, ATT_EDITOR_CONTRIBUTOR);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create editor contributor: " + this.id, e.getStatus());
        }
        return contributor;
    }

    public String getClassName() {
        return this.className;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getFileName() {
        if (this.program == null) {
            return this.fileName;
        }
        return this.program.getName();
    }

    public String getId() {
        if (this.program == null) {
            return this.id;
        }
        return this.program.getName();
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.testImage) {
            this.testImage = false;
            if (this.imageDesc == null) {
                this.imageDesc = WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
            } else {
                Image img = this.imageDesc.createImage(false);
                if (img == null) {
                    this.imageDesc = WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
                } else {
                    img.dispose();
                }
            }
        }
        return this.imageDesc;
    }

    public String getImageFilename() {
        return this.imageFilename;
    }

    public String getLabel() {
        if (this.program == null) {
            return this.editorName;
        }
        return this.program.getName();
    }

    public String getLauncher() {
        return this.launcherName;
    }

    public String getPluginID() {
        return this.pluginIdentifier;
    }

    public Program getProgram() {
        return this.program;
    }

    public boolean isInternal() {
        return this.openMode == 1;
    }

    public boolean isOpenInPlace() {
        return this.openMode == 2;
    }

    public boolean isOpenExternal() {
        return this.openMode == 4;
    }

    protected boolean loadValues(IMemento memento) {
        this.editorName = memento.getString("label");
        this.imageFilename = memento.getString("image");
        this.className = memento.getString("class");
        this.launcherName = memento.getString("launcher");
        this.fileName = memento.getString("file");
        this.id = memento.getString("id");
        this.pluginIdentifier = memento.getString("plugin");
        Integer openModeInt = memento.getInteger("openMode");
        if (openModeInt != null) {
            this.openMode = openModeInt;
        } else {
            boolean internal = new Boolean(memento.getString("internal"));
            boolean openInPlace = new Boolean(memento.getString("open_in_place"));
            this.openMode = internal ? 1 : (openInPlace ? 2 : 4);
        }
        if (this.openMode != 4 && this.openMode != 1 && this.openMode != 2) {
            WorkbenchPlugin.log("Ignoring editor descriptor with invalid openMode: " + this);
            return false;
        }
        String programName = memento.getString("program_name");
        if (programName != null) {
            this.program = EditorDescriptor.findProgram(programName);
        }
        return true;
    }

    protected void saveValues(IMemento memento) {
        memento.putString("label", this.editorName);
        memento.putString("image", this.imageFilename);
        memento.putString("class", this.className);
        memento.putString("launcher", this.launcherName);
        memento.putString("file", this.fileName);
        memento.putString("id", this.id);
        memento.putString("plugin", this.pluginIdentifier);
        memento.putInteger("openMode", this.openMode);
        memento.putString("internal", String.valueOf(this.isInternal()));
        memento.putString("open_in_place", String.valueOf(this.isOpenInPlace()));
        if (this.program != null) {
            memento.putString("program_name", this.program.getName());
        }
    }

    void setClassName(String newClassName) {
        this.className = newClassName;
    }

    void setConfigurationElement(IConfigurationElement newConfigurationElement) {
        this.configurationElement = newConfigurationElement;
    }

    void setFileName(String aFileName) {
        this.fileName = aFileName;
    }

    void setID(String anID) {
        this.id = anID;
    }

    void setImageDescriptor(ImageDescriptor desc) {
        this.imageDesc = desc;
        this.testImage = true;
    }

    void setImageFilename(String aFileName) {
        this.imageFilename = aFileName;
    }

    void setLauncher(String newLauncher) {
        this.launcherName = newLauncher;
    }

    void setName(String newName) {
        this.editorName = newName;
    }

    public void setOpenMode(int mode) {
        this.openMode = mode;
    }

    void setPluginIdentifier(String anID) {
        this.pluginIdentifier = anID;
    }

    void setProgram(Program newProgram) {
        this.program = newProgram;
        if (this.editorName == null) {
            this.setName(newProgram.getName());
        }
    }

    public String toString() {
        return "EditorDescriptor(" + this.editorName + ")";
    }

    public boolean fromPlugin() {
        return this.configurationElement != null;
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.pluginIdentifier;
    }
}

