/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.strategy;

import java.io.Serializable;

public abstract class TypeBindingStrategy {
    public static final TypeBindingStrategy DEFAULT = new Default();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public abstract BindingType bindingType(Class var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Default
    extends TypeBindingStrategy {
        public BindingType bindingType(Class type) {
            BindingType result = BindingType.COMPLEX;
            if (this.isStandardPrimitive(type)) {
                result = BindingType.PRIMITIVE;
            }
            return result;
        }

        protected boolean isStandardPrimitive(Class type) {
            if (type == null) {
                return false;
            }
            if (type.isPrimitive()) {
                return true;
            }
            if (type.equals(class$java$lang$Object == null ? (class$java$lang$Object = TypeBindingStrategy.class$("java.lang.Object")) : class$java$lang$Object)) {
                return false;
            }
            return type.getName().startsWith("java.lang.") || (class$java$lang$Number == null ? (class$java$lang$Number = TypeBindingStrategy.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type) || (class$java$lang$String == null ? (class$java$lang$String = TypeBindingStrategy.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type) || (class$java$util$Date == null ? (class$java$util$Date = TypeBindingStrategy.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(type) || (class$java$sql$Date == null ? (class$java$sql$Date = TypeBindingStrategy.class$("java.sql.Date")) : class$java$sql$Date).isAssignableFrom(type) || (class$java$sql$Time == null ? (class$java$sql$Time = TypeBindingStrategy.class$("java.sql.Time")) : class$java$sql$Time).isAssignableFrom(type) || (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = TypeBindingStrategy.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).isAssignableFrom(type) || (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeBindingStrategy.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(type) || (class$java$math$BigInteger == null ? (class$java$math$BigInteger = TypeBindingStrategy.class$("java.math.BigInteger")) : class$java$math$BigInteger).isAssignableFrom(type);
        }
    }

    public static final class BindingType
    implements Serializable {
        private static final int COMPLEX_INDICATOR = 1;
        private static final int PRIMITIVE_INDICATOR = 2;
        public static final BindingType COMPLEX = new BindingType(1);
        public static final BindingType PRIMITIVE = new BindingType(2);
        private int type;

        private BindingType(int type) {
            this.type = type;
        }

        public boolean equals(Object object) {
            boolean result = false;
            if (object instanceof BindingType) {
                BindingType bindingType = (BindingType)object;
                result = this.type == bindingType.type;
            }
            return result;
        }

        public int hashCode() {
            return this.type;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("BindingType: ");
            switch (this.type) {
                case 1: {
                    buffer.append("COMPLEX");
                    break;
                }
                case 2: {
                    buffer.append("PRIMITIVE");
                }
            }
            return buffer.toString();
        }
    }
}

