/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewerImpl;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeEditor;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableTreeViewer
extends AbstractTreeViewer {
    private TableViewerImpl tableViewerImpl;
    private TableTree tableTree;
    private TableTreeEditor tableTreeEditor;

    public TableTreeViewer(TableTree tree) {
        this.tableTree = tree;
        this.hookControl((Control)tree);
        this.tableTreeEditor = new TableTreeEditor(this.tableTree);
        this.tableViewerImpl = new TableTreeViewerImpl(this);
    }

    public TableTreeViewer(Composite parent) {
        this(parent, 2818);
    }

    public TableTreeViewer(Composite parent, int style) {
        this(new TableTree(parent, style));
    }

    protected void addTreeListener(Control c, TreeListener listener) {
        ((TableTree)c).addTreeListener(listener);
    }

    public void cancelEditing() {
        this.tableViewerImpl.cancelEditing();
    }

    protected void doUpdateItem(Item item, Object element) {
        IBaseLabelProvider prov = this.getLabelProvider();
        ITableLabelProvider tprov = null;
        ILabelProvider lprov = null;
        if (prov instanceof ITableLabelProvider) {
            tprov = (ITableLabelProvider)prov;
        } else {
            lprov = (ILabelProvider)prov;
        }
        int columnCount = this.tableTree.getTable().getColumnCount();
        TableTreeItem ti = (TableTreeItem)item;
        int column = 0;
        while (column < columnCount || column == 0) {
            String text = "";
            Image image = null;
            if (tprov != null) {
                text = tprov.getColumnText(element, column);
                image = tprov.getColumnImage(element, column);
            } else if (column == 0) {
                text = lprov.getText(element);
                image = lprov.getImage(element);
            }
            ti.setText(column, text);
            if (ti.getImage(column) != image) {
                ti.setImage(column, image);
            }
            ++column;
        }
        if (prov instanceof IColorProvider) {
            IColorProvider cprov = (IColorProvider)((Object)prov);
            ti.setForeground(cprov.getForeground(element));
            ti.setBackground(cprov.getBackground(element));
        }
        if (prov instanceof IFontProvider) {
            IFontProvider fprov = (IFontProvider)((Object)prov);
            ti.setFont(fprov.getFont(element));
        }
    }

    public void editElement(Object element, int column) {
        this.tableViewerImpl.editElement(element, column);
    }

    public CellEditor[] getCellEditors() {
        return this.tableViewerImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.tableViewerImpl.getCellModifier();
    }

    protected Item[] getChildren(Widget o) {
        if (o instanceof TableTreeItem) {
            return ((TableTreeItem)o).getItems();
        }
        if (o instanceof TableTree) {
            return ((TableTree)o).getItems();
        }
        return null;
    }

    public Object[] getColumnProperties() {
        return this.tableViewerImpl.getColumnProperties();
    }

    public Control getControl() {
        return this.tableTree;
    }

    public Object getElementAt(int index) {
        TableTreeItem i = this.tableTree.getItems()[index];
        if (i != null) {
            return i.getData();
        }
        return null;
    }

    protected boolean getExpanded(Item item) {
        return ((TableTreeItem)item).getExpanded();
    }

    protected Item getItem(int x, int y) {
        return this.getTableTree().getTable().getItem(this.getTableTree().toControl(new Point(x, y)));
    }

    protected int getItemCount(Control widget) {
        return ((TableTree)widget).getItemCount();
    }

    protected int getItemCount(Item item) {
        return ((TableTreeItem)item).getItemCount();
    }

    protected Item[] getItems(Item item) {
        return ((TableTreeItem)item).getItems();
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected Item getParentItem(Item item) {
        return ((TableTreeItem)item).getParentItem();
    }

    protected Item[] getSelection(Control widget) {
        return ((TableTree)widget).getSelection();
    }

    public TableTree getTableTree() {
        return this.tableTree;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.tableTree.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TableItem[] items = TableTreeViewer.this.tableTree.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    Rectangle rect = items[i].getImageBounds(0);
                    if (rect.contains(e.x, e.y)) {
                        return;
                    }
                    ++i;
                }
                TableTreeViewer.this.tableViewerImpl.handleMouseDown(e);
            }
        });
    }

    public boolean isCellEditorActive() {
        return this.tableViewerImpl.isCellEditorActive();
    }

    protected Item newItem(Widget parent, int flags, int ix) {
        TableTreeItem item = ix >= 0 ? (parent instanceof TableTreeItem ? new TableTreeItem((TableTreeItem)parent, flags, ix) : new TableTreeItem((TableTree)parent, flags, ix)) : (parent instanceof TableTreeItem ? new TableTreeItem((TableTreeItem)parent, flags) : new TableTreeItem((TableTree)parent, flags));
        return item;
    }

    protected void removeAll(Control widget) {
        ((TableTree)widget).removeAll();
    }

    public void setCellEditors(CellEditor[] editors) {
        this.tableViewerImpl.setCellEditors(editors);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.tableViewerImpl.setCellModifier(modifier);
    }

    public void setColumnProperties(String[] columnProperties) {
        this.tableViewerImpl.setColumnProperties(columnProperties);
    }

    protected void setExpanded(Item node, boolean expand) {
        ((TableTreeItem)node).setExpanded(expand);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue(labelProvider instanceof ITableLabelProvider || labelProvider instanceof ILabelProvider);
        super.setLabelProvider(labelProvider);
    }

    protected void setSelection(List items) {
        TableTreeItem[] newItems = new TableTreeItem[items.size()];
        items.toArray(newItems);
        this.getTableTree().setSelection(newItems);
    }

    protected void showItem(Item item) {
        this.getTableTree().showItem((TableTreeItem)item);
    }

    class TableTreeViewerImpl
    extends TableViewerImpl {
        public TableTreeViewerImpl(TableTreeViewer viewer) {
            super(viewer);
        }

        Rectangle getBounds(Item item, int columnNumber) {
            return ((TableTreeItem)item).getBounds(columnNumber);
        }

        int getColumnCount() {
            return TableTreeViewer.this.getTableTree().getTable().getColumnCount();
        }

        Item[] getSelection() {
            return TableTreeViewer.this.getTableTree().getSelection();
        }

        void setEditor(Control w, Item item, int columnNumber) {
            TableTreeViewer.this.tableTreeEditor.setEditor(w, (TableTreeItem)item, columnNumber);
        }

        void setSelection(StructuredSelection selection, boolean b) {
            TableTreeViewer.this.setSelection(selection, b);
        }

        void showSelection() {
            TableTreeViewer.this.getTableTree().showSelection();
        }

        void setLayoutData(CellEditor.LayoutData layoutData) {
            ((TableTreeViewer)TableTreeViewer.this).tableTreeEditor.horizontalAlignment = layoutData.horizontalAlignment;
            ((TableTreeViewer)TableTreeViewer.this).tableTreeEditor.grabHorizontal = layoutData.grabHorizontal;
            ((TableTreeViewer)TableTreeViewer.this).tableTreeEditor.minimumWidth = layoutData.minimumWidth;
        }

        void handleDoubleClickEvent() {
            StructuredViewer viewer = this.getViewer();
            TableTreeViewer.this.fireDoubleClick(new DoubleClickEvent(viewer, ((Viewer)viewer).getSelection()));
            TableTreeViewer.this.fireOpen(new OpenEvent(viewer, ((Viewer)viewer).getSelection()));
        }
    }
}

