/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.utils.Cache;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class ContentDescriptionManager
implements IManager {
    private Cache cache;

    Cache getCache() {
        return this.cache;
    }

    public IContentDescription getDescriptionFor(File file, ResourceInfo info) throws CoreException {
        IContentTypeManager contentTypeManager;
        IContentType type;
        if (info == null) {
            return null;
        }
        int flags = info.getFlags();
        if ((flags & 0x20000) != 0) {
            return null;
        }
        if ((flags & 0x40000) != 0 && (type = (contentTypeManager = Platform.getContentTypeManager()).findContentTypeFor(file.getName())) != null) {
            return ((ContentType)type).getDefaultDescription();
        }
        info.clear(393216);
        ContentDescriptionManager contentDescriptionManager = this;
        synchronized (contentDescriptionManager) {
            Cache.Entry entry = this.cache.getEntry(file.getFullPath());
            if (entry != null && entry.getTimestamp() == (long)info.getContentId()) {
                return (IContentDescription)entry.getCached();
            }
            IContentDescription newDescription = this.readDescription(file);
            if (newDescription == null) {
                info.set(131072);
                return null;
            }
            if (((ContentType)newDescription.getContentType()).getDefaultDescription() == newDescription) {
                IContentType defaultForName = Platform.getContentTypeManager().findContentTypeFor(file.getName());
                if (newDescription.getContentType() == defaultForName) {
                    info.set(262144);
                    return newDescription;
                }
            }
            if (entry == null) {
                entry = this.cache.addEntry(file.getFullPath(), newDescription, info.getContentId());
            } else {
                entry.setTimestamp(info.getContentId());
                entry.setCached(newDescription);
            }
            return newDescription;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IContentDescription readDescription(File file) throws CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        InputStream contents = file.getContents(true);
        try {
            try {
                IContentDescription newDescription;
                IContentDescription iContentDescription = newDescription = contentTypeManager.getDescriptionFor(contents, file.getName(), IContentDescription.ALL);
                Object var6_7 = null;
                file.ensureClosed(contents);
                return iContentDescription;
            }
            catch (IOException e) {
                String message = Policy.bind("resources.errorContentDescription", file.getFullPath().toString());
                throw new ResourceException(381, file.getFullPath(), message, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            file.ensureClosed(contents);
            throw throwable;
        }
    }

    public void shutdown(IProgressMonitor monitor) throws CoreException {
        this.cache.discardAll();
        this.cache = null;
    }

    public void startup(IProgressMonitor monitor) throws CoreException {
        this.cache = new Cache(100, 1000, 0.1);
    }
}

