/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.util;

import java.io.File;

public abstract class AbstractBasicFileApplication {
    private boolean needSave;
    private File file;
    private String fileExtension;
    protected String defaultFileName = "\u7121\u984c";
    protected String headFileSaveMessage = "\u30d5\u30a1\u30a4\u30eb ";
    protected String tailFileSaveMessage = " \u306f\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u4fdd\u5b58\u3057\u307e\u3059\u304b?";
    protected String fileSaveTitle = "\u30d5\u30a1\u30a4\u30eb\u4fdd\u5b58\u306e\u78ba\u8a8d";
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String defaultExtension) {
        this.fileExtension = defaultExtension;
    }

    public String fixFileExtension(String path) {
        if (this.getFileExtension() == null) {
            return path;
        }
        if (path.toLowerCase().endsWith("." + this.getFileExtension().toLowerCase())) {
            return path;
        }
        return String.valueOf(path) + "." + this.getFileExtension();
    }

    public String getDefaultFileName() {
        return this.defaultFileName;
    }

    public void setDefaultFileName(String defaultFileName) {
        this.defaultFileName = defaultFileName;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileSaveTitle() {
        return this.fileSaveTitle;
    }

    public void setFileSaveTitle(String fileSaveTitle) {
        this.fileSaveTitle = fileSaveTitle;
    }

    public String getHeadFileSaveMessage() {
        return this.headFileSaveMessage;
    }

    public void setHeadFileSaveMessage(String headFileSaveMessage) {
        this.headFileSaveMessage = headFileSaveMessage;
    }

    public String getTailFileSaveMessage() {
        return this.tailFileSaveMessage;
    }

    public void setTailFileSaveMessage(String tailFileSaveMessage) {
        this.tailFileSaveMessage = tailFileSaveMessage;
    }

    public boolean isNeedSave() {
        return this.needSave;
    }

    public void setNeedSave(boolean bool) {
        this.needSave = bool;
    }

    public void openFile() {
        int result;
        if (this.isNeedSave() && ((result = this.askSave()) == 0 ? !this.saveFile() : result == 2)) {
            return;
        }
        this.file = this.execChooseOpenFile();
        if (this.file != null) {
            this.execOpen();
            this.needSave = false;
        }
        this.updateTitle();
    }

    protected abstract void execOpen();

    protected abstract File execChooseOpenFile();

    protected abstract void execSave();

    protected abstract void updateTitle();

    protected abstract File execChooseSaveFile();

    public String getFileName() {
        if (this.file == null) {
            return this.defaultFileName;
        }
        return this.file.getName();
    }

    public int askSave() {
        return this.executeAskSave(this.fileSaveTitle, String.valueOf(this.headFileSaveMessage) + this.getFileName() + this.tailFileSaveMessage);
    }

    protected abstract int executeAskSave(String var1, String var2);

    public boolean saveFile() {
        if (this.file == null) {
            this.file = this.execChooseSaveFile();
        }
        if (this.file != null) {
            this.execSave();
            this.needSave = false;
            this.updateTitle();
            return true;
        }
        return false;
    }

    public boolean saveAsFile() {
        File tmpFile = this.execChooseSaveFile();
        if (tmpFile != null) {
            this.file = tmpFile;
            this.execSave();
            this.needSave = false;
            this.updateTitle();
            return true;
        }
        return false;
    }

    public void newFile() {
        int result;
        if (this.isNeedSave() && ((result = this.askSave()) == 0 ? !this.saveFile() : result == 2)) {
            return;
        }
        this.execNew();
        this.file = null;
        this.needSave = false;
        this.updateTitle();
    }

    protected abstract void execNew();

    protected abstract void execExit();
}

