/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.presentations.DefaultPartPresentation;
import org.eclipse.ui.internal.presentations.PaneFolder;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.themes.ITheme;

public class DefaultViewPresentation
extends DefaultPartPresentation {
    private IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
    private IPreferenceStore apiPreferenceStore = PrefUtil.getAPIPreferenceStore();
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (DefaultViewPresentation.this.isDisposed()) {
                return;
            }
            if ("VIEW_TAB_POSITION".equals(propertyChangeEvent.getProperty()) && !DefaultViewPresentation.this.isDisposed()) {
                int tabLocation = DefaultViewPresentation.this.preferenceStore.getInt("VIEW_TAB_POSITION");
                DefaultViewPresentation.this.getTabFolder().setTabPosition(tabLocation);
                DefaultViewPresentation.this.layout(false);
            } else if ("SHOW_TRADITIONAL_STYLE_TABS".equals(propertyChangeEvent.getProperty()) && !DefaultViewPresentation.this.isDisposed()) {
                boolean traditionalTab = DefaultViewPresentation.this.apiPreferenceStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
                DefaultViewPresentation.this.setTabStyle(traditionalTab);
            }
        }
    };

    public DefaultViewPresentation(Composite parent, IStackPresentationSite newSite) {
        super(new PaneFolder(parent, 2048), newSite);
        PaneFolder tabFolder = this.getTabFolder();
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
        this.apiPreferenceStore.addPropertyChangeListener(this.propertyChangeListener);
        int tabLocation = this.preferenceStore.getInt("VIEW_TAB_POSITION");
        tabFolder.setTabPosition(tabLocation);
        this.setTabStyle(this.apiPreferenceStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        tabFolder.setUnselectedCloseVisible(false);
        tabFolder.setUnselectedImageVisible(false);
        this.init();
    }

    protected void setTabStyle(boolean traditionalTab) {
        this.getTabFolder().setSimpleTab(traditionalTab);
    }

    protected void updateGradient() {
        Font oldTabFont;
        if (this.isDisposed()) {
            return;
        }
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        if (this.isActive()) {
            this.setActiveTabColors();
        } else {
            this.setInactiveTabColors();
        }
        boolean resizeNeeded = false;
        CTabItem item = this.getTabFolder().getSelection();
        Font tabFont = theme.getFontRegistry().get("org.eclipse.ui.workbench.TAB_TEXT_FONT");
        if (item != null && !this.getPartForTab(item).isBusy()) {
            item.setFont(null);
        }
        if (!(oldTabFont = this.getTabFolder().getControl().getFont()).equals((Object)tabFont)) {
            this.getTabFolder().getControl().setFont(tabFont);
            resizeNeeded = true;
        }
        super.updateGradient();
        if (resizeNeeded) {
            this.getTabFolder().setTabHeight(this.computeTabHeight());
            this.setControlSize();
        }
    }

    public void setActive(int newState) {
        super.setActive(newState);
        this.updateGradient();
    }

    protected void widgetDisposed() {
        this.preferenceStore.removePropertyChangeListener(this.propertyChangeListener);
        this.apiPreferenceStore.removePropertyChangeListener(this.propertyChangeListener);
        super.widgetDisposed();
    }

    protected String getPaneName() {
        return WorkbenchMessages.getString("ViewPane.moveView");
    }
}

