/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.ui;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jpn.xucker.rcp.ui.GraphMemoryLabelProvider;
import org.jpn.xucker.rcp.ui.NumberLabelProvider;
import org.jpn.xucker.rcp.ui.SimpleGraphMemoryPainter;

public class ImageMemoryComposite
extends Composite {
    private FigureCanvas canvas;
    private Image image;
    ScalableLayeredPane panel;
    private HMemoryCanvas horizontalMemory;
    private VMemoryCanvas verticalMemory;
    private Label label;
    private double[] zooms = new double[]{0.05125, 0.125, 0.25, 0.5, 1.0, 2.0, 4.0, 8.0, 16.0, 32.0};
    private int[] grids = new int[]{100, 100, 100, 100, 100, 100, 100, 96, 96, 96};
    private int currentZoom = 4;
    int horizontalMemoryStart;
    int verticalMemoryStart;
    private int maxHorizontalValue = 30000;
    private int maxVerticalValue = 30000;
    private GraphMemoryLabelProvider vscrollLabelProvider = new NumberLabelProvider();
    private GraphMemoryLabelProvider hscrollLabelProvider = new NumberLabelProvider();

    public ScalableLayeredPane gerScalableLayeredPane() {
        return this.panel;
    }

    public int getHorizontalMemoryStart() {
        return this.horizontalMemoryStart;
    }

    public void setHorizontalMemoryStart(int horizontalMemoryStart) {
        this.horizontalMemoryStart = horizontalMemoryStart;
    }

    public int getVerticalMemoryStart() {
        return this.verticalMemoryStart;
    }

    public void setVerticalMemoryStart(int verticalMemoryStart) {
        this.verticalMemoryStart = verticalMemoryStart;
    }

    public int getMaxHorizontalValue() {
        return this.maxHorizontalValue;
    }

    public void setMaxHorizontalValue(int maxHorizontalValue) {
        this.maxHorizontalValue = maxHorizontalValue;
    }

    public int getMaxVerticalValue() {
        return this.maxVerticalValue;
    }

    public void setMaxVerticalValue(int maxVerticalValue) {
        this.maxVerticalValue = maxVerticalValue;
    }

    public SimpleGraphMemoryPainter getHorizontalGraphPainter() {
        return this.horizontalMemory.getGraphMemoryPainter();
    }

    public SimpleGraphMemoryPainter getVerticalGraphPainter() {
        return this.verticalMemory.getGraphMemoryPainter();
    }

    public ImageMemoryComposite(Composite parent, int style) {
        this(parent, style, 32, 32);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public ImageMemoryComposite(Composite parent, int style, int memoryWidth, int memoryHeight) {
        super(parent, style);
        ImageMemoryComposite base = this;
        GridLayout gridlayout = new GridLayout(2, false);
        gridlayout.horizontalSpacing = 0;
        gridlayout.verticalSpacing = 0;
        gridlayout.marginHeight = 0;
        gridlayout.marginWidth = 0;
        base.setLayout((Layout)gridlayout);
        Composite space = new Composite((Composite)base, 0);
        GridData s1 = new GridData();
        s1.widthHint = memoryHeight;
        s1.heightHint = memoryWidth;
        space.setLayoutData((Object)s1);
        this.horizontalMemory = new HMemoryCanvas(base, 0);
        GridData c2 = new GridData(768);
        c2.heightHint = memoryWidth;
        this.horizontalMemory.setLayoutData(c2);
        this.verticalMemory = new VMemoryCanvas(base, 0);
        GridData c1 = new GridData(1040);
        c1.widthHint = memoryHeight;
        this.verticalMemory.setLayoutData(c1);
        this.canvas = new FigureCanvas((Composite)base);
        this.canvas.getVerticalBar().addSelectionListener((SelectionListener)this.verticalMemory);
        this.canvas.getHorizontalBar().addSelectionListener((SelectionListener)this.horizontalMemory);
        this.canvas.setLayoutData((Object)new GridData(1808));
        Panel tmp = new Panel();
        tmp.setLayoutManager((LayoutManager)new FlowLayout());
        this.panel = new ScalableLayeredPane();
        this.panel.setLayoutManager((LayoutManager)new FlowLayout(false));
        this.canvas.setContents((IFigure)tmp);
        tmp.add((IFigure)this.panel);
        this.panel.setScale(1.0);
        this.label = new Label();
        this.panel.add((IFigure)this.label);
        this.canvas.addControlListener((ControlListener)new ResizeCheck());
        this.verticalMemory.setPosition(memoryHeight);
        this.horizontalMemory.setPosition(memoryWidth);
    }

    private void start() {
    }

    public void zoomUp() {
        if (this.currentZoom < this.zooms.length - 1) {
            ++this.currentZoom;
            double zoom = this.zooms[this.currentZoom];
            this.horizontalMemory.setGrid(this.grids[this.currentZoom]);
            this.verticalMemory.setGrid(this.grids[this.currentZoom]);
            this.horizontalMemory.setZoom(zoom);
            this.verticalMemory.setZoom(zoom);
            this.panel.setScale(zoom);
            this.verticalMemory.redraw();
            this.horizontalMemory.redraw();
        }
    }

    public void zoomDown() {
        if (this.currentZoom > 0) {
            --this.currentZoom;
            double zoom = this.zooms[this.currentZoom];
            this.panel.setScale(zoom);
            this.horizontalMemory.setGrid(this.grids[this.currentZoom]);
            this.verticalMemory.setGrid(this.grids[this.currentZoom]);
            this.horizontalMemory.setZoom(zoom);
            this.verticalMemory.setZoom(zoom);
            this.canvas.scrollToY((this.canvas.getVerticalBar().getSelection() - this.canvas.getVerticalBar().getThumb()) / 2);
            this.verticalMemory.redraw();
            this.canvas.scrollToY((this.canvas.getHorizontalBar().getSelection() - this.canvas.getHorizontalBar().getThumb()) / 2);
            this.horizontalMemory.redraw();
        }
    }

    public void init() {
        this.horizontalMemory.setZoom(1.0);
        this.verticalMemory.setZoom(1.0);
        this.panel.setScale(1.0);
        this.canvas.scrollToX(0);
        this.canvas.scrollToY(0);
        this.currentZoom = 4;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public GraphMemoryLabelProvider getHscrollLabelProvider() {
        return this.hscrollLabelProvider;
    }

    public void setHscrollLabelProvider(GraphMemoryLabelProvider hscrollLabelProvider) {
        this.hscrollLabelProvider = hscrollLabelProvider;
        this.getHorizontalGraphPainter().setMainLabel(hscrollLabelProvider.createLabel(this.horizontalMemory.getZoom()));
    }

    public GraphMemoryLabelProvider getVscrollLabelProvider() {
        return this.vscrollLabelProvider;
    }

    public void setVscrollLabelProvider(GraphMemoryLabelProvider vscrollLabelProvider) {
        this.vscrollLabelProvider = vscrollLabelProvider;
        this.getVerticalGraphPainter().setMainLabel(vscrollLabelProvider.createLabel(this.verticalMemory.getZoom()));
    }

    public Image getImage() {
        return this.label.getIcon();
    }

    public void setImage(Image image) {
        this.label.setIcon(image);
        this.init();
    }

    public class ResizeCheck
    implements ControlListener {
        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            ImageMemoryComposite.this.verticalMemory.redraw();
            ImageMemoryComposite.this.horizontalMemory.redraw();
        }
    }

    public class VMemoryCanvas
    extends AbstractMemoryCanvas {
        public VMemoryCanvas(Composite parent, int style) {
            super(parent, style);
            this.painter.setVerticalGraph(true);
            this.painter.setGraphPlus(true);
            this.painter.setMainLabel(ImageMemoryComposite.this.vscrollLabelProvider.createLabel(this.zoom));
        }

        public void setZoom(double zoom) {
            this.zoom = zoom;
            this.painter.setMainLabel(ImageMemoryComposite.this.vscrollLabelProvider.createLabel(zoom));
            this.redraw();
        }

        public void paintControl(PaintEvent e) {
            this.painter.draw(e.gc, this.position - 1, 0 - ImageMemoryComposite.this.canvas.getVerticalBar().getSelection() + ImageMemoryComposite.this.verticalMemoryStart, ImageMemoryComposite.this.maxVerticalValue);
        }
    }

    public abstract class AbstractMemoryCanvas
    extends Canvas
    implements PaintListener,
    SelectionListener {
        double zoom = 1.0;
        int per = 100;
        int position = 50;
        SimpleGraphMemoryPainter painter = new SimpleGraphMemoryPainter();

        public double getZoom() {
            return this.zoom;
        }

        public void setZoom(double zoom) {
            this.zoom = zoom;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public AbstractMemoryCanvas(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
        }

        public SimpleGraphMemoryPainter getGraphMemoryPainter() {
            return this.painter;
        }

        public void setGrid(int size) {
            this.painter.setPerMain(size);
        }

        public void widgetSelected(SelectionEvent e) {
            this.redraw();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class HMemoryCanvas
    extends AbstractMemoryCanvas {
        public HMemoryCanvas(Composite parent, int style) {
            super(parent, style);
            this.painter.setVerticalGraph(false);
            this.painter.setGraphPlus(true);
            this.painter.setMainLabel(ImageMemoryComposite.this.hscrollLabelProvider.createLabel(this.zoom));
        }

        public void paintControl(PaintEvent e) {
            this.painter.draw(e.gc, 0 - ImageMemoryComposite.this.canvas.getHorizontalBar().getSelection() + ImageMemoryComposite.this.horizontalMemoryStart, this.position - 1, ImageMemoryComposite.this.maxHorizontalValue);
        }

        public void setZoom(double zoom) {
            this.zoom = zoom;
            this.painter.setMainLabel(ImageMemoryComposite.this.hscrollLabelProvider.createLabel(zoom));
            this.redraw();
        }
    }
}

