/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.audiotools.ffmpeg;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.jpn.xucker.rcp.audio.AudioConverter;
import org.jpn.xucker.rcp.audio.AudioSetting;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;
import org.jpn.xucker.rcp.audiotools.tools.ToolsUtil;

public class FFMpegTools
implements AudioConverter {
    public static IConsoleManager consoleManager;
    private MessageConsoleStream consoleStream;
    private MessageConsoleStream errorStream;
    private MessageConsoleStream progressStream;
    private MessageConsole console;

    public boolean canConvert(String input, String output) {
        String path = this.getFFMpegPath();
        if (!new File(path).exists() || !new File(path).getName().toLowerCase().endsWith("ffmpeg.exe")) {
            return false;
        }
        String[] canInput = new String[]{"mp3", "wav", "ac3", "mp2", "dts"};
        String[] canOutput = new String[]{"mp3", "wav", "ac3", "mp2", "flv", "swf", "3gp"};
        int j = 0;
        while (j < canInput.length) {
            if (input.equals(canInput[j])) {
                int i = 0;
                while (i < canOutput.length) {
                    if (output.equals(canOutput[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            ++j;
        }
        return false;
    }

    private String getFFMpegPath() {
        return AudioToolsPlugin.getDefault().getPluginPreferences().getString("ffmpegPath");
    }

    public String[] toArgs(File input, File output, AudioSetting setting, AudioSetting inputSetting) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(this.getFFMpegPath());
        argList.add("-y");
        argList.add("-i");
        argList.add(input.getAbsolutePath());
        String inputExtension = ToolsUtil.getExtension(input.getName());
        String outputExtension = ToolsUtil.getExtension(output.getName());
        if (outputExtension.equals("wav")) {
            if (setting != null) {
                if (setting.getSamplebit() == 16) {
                    argList.add("-acodec");
                    argList.add("pcm_s16le");
                } else if (setting.getSamplebit() == 8) {
                    argList.add("-acodec");
                    argList.add("pcm_u8");
                }
                if (setting.getChannel() > 0) {
                    argList.add("-ac");
                    argList.add("" + setting.getChannel());
                }
                if (setting.getSamplerate() > 0) {
                    argList.add("-ar");
                    argList.add("" + setting.getSamplerate());
                }
            } else {
                argList.add("-acodec");
                argList.add("pcm_s16le");
            }
        } else if (outputExtension.equals("flv") || outputExtension.equals("swf")) {
            argList.add("-acodec");
            argList.add("mp3");
            if (setting != null) {
                if (setting.getChannel() > 0) {
                    argList.add("-ac");
                    argList.add("" + setting.getChannel());
                }
                if (setting.getSamplerate() > 0) {
                    argList.add("-ar");
                    argList.add("" + setting.getSamplerate());
                }
                if (setting.getBitrate() > 0) {
                    argList.add("-ab");
                    argList.add("" + setting.getBitrate() / 1000);
                }
            } else {
                System.out.println("ar:" + inputSetting.getSamplerate());
                int ar = inputSetting.getSamplerate() >= 44100 ? 44100 : (inputSetting.getSamplerate() >= 22050 ? 22050 : 11025);
                argList.add("-ar");
                argList.add("" + ar);
                if (inputSetting.getBitrate() > 0 && inputExtension.equals("mp3")) {
                    argList.add("-ab");
                    argList.add("" + inputSetting.getBitrate() / 1000);
                }
            }
        } else if (outputExtension.equals("3gp")) {
            argList.add("-ac");
            argList.add("1");
            argList.add("-ar");
            argList.add("8000");
            if (setting != null && setting.getBitrate() > 0) {
                argList.add("-ab");
                argList.add("" + setting.getBitrate() / 1000);
            }
        } else if (outputExtension.equals("mp2")) {
            if (setting != null) {
                if (setting.getChannel() > 0) {
                    argList.add("-ac");
                    argList.add("" + setting.getChannel());
                }
                if (setting.getSamplerate() > 0) {
                    argList.add("-ar");
                    argList.add("" + setting.getSamplerate());
                }
                if (setting.getBitrate() > 0) {
                    argList.add("-ab");
                    argList.add("" + setting.getBitrate() / 1000);
                }
            } else {
                argList.add("-ab");
                argList.add("" + AudioToolsPlugin.getDefault().getPreferenceStore().getInt("mp2DefaultBitrate"));
                int ar = inputSetting.getSamplerate() >= 48000 ? 48000 : (inputSetting.getSamplerate() >= 44100 ? 44100 : (inputSetting.getSamplerate() >= 32000 ? 32000 : (inputSetting.getSamplerate() >= 22050 ? 22050 : 16000)));
                argList.add("-ar");
                argList.add("" + ar);
            }
        } else if (outputExtension.equals("ac3")) {
            if (setting != null) {
                if (setting.getChannel() > 0) {
                    argList.add("-ac");
                    argList.add("" + setting.getChannel());
                }
                if (setting.getSamplerate() > 0) {
                    argList.add("-ar");
                    argList.add("" + setting.getSamplerate());
                }
                if (setting.getBitrate() > 0) {
                    argList.add("-ab");
                    argList.add("" + setting.getBitrate() / 1000);
                }
            } else {
                argList.add("-ab");
                argList.add("" + AudioToolsPlugin.getDefault().getPreferenceStore().getInt("ac3DefaultBitrate"));
                int ar = inputSetting.getSamplerate() >= 48000 ? 48000 : (inputSetting.getSamplerate() >= 44100 ? 44100 : 32000);
                argList.add("-ar");
                argList.add("" + ar);
            }
        } else if (outputExtension.equals("mp3")) {
            if (setting != null) {
                if (setting.getChannel() > 0) {
                    argList.add("-ac");
                    argList.add("" + setting.getChannel());
                }
                if (setting.getSamplerate() > 0) {
                    argList.add("-ar");
                    argList.add("" + setting.getSamplerate());
                }
                if (setting.getBitrate() > 0) {
                    argList.add("-ab");
                    argList.add("" + setting.getBitrate() / 1000);
                }
            } else {
                argList.add("-ab");
                argList.add("" + AudioToolsPlugin.getDefault().getPreferenceStore().getInt("mp3DefaultBitrate"));
            }
        } else if (setting != null) {
            if (setting.getChannel() > 0) {
                argList.add("-ac");
                argList.add("" + setting.getChannel());
            }
            if (setting.getSamplerate() > 0) {
                argList.add("-ar");
                argList.add("" + setting.getSamplerate());
            }
            if (setting.getBitrate() > 0) {
                argList.add("-ab");
                argList.add("" + setting.getBitrate() / 1000);
            }
        }
        argList.add(output.getAbsolutePath());
        return argList.toArray(new String[argList.size()]);
    }

    public void convert(File input, File output, AudioSetting setting, AudioSetting inputSetting) throws IOException {
        String errorLine;
        if (consoleManager == null) {
            consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            this.console = new MessageConsole(this.getName(), null);
            consoleManager.addConsoles(new IConsole[]{this.console});
            this.consoleStream = this.console.newMessageStream();
            this.errorStream = this.console.newMessageStream();
            this.progressStream = this.console.newMessageStream();
        } else {
            consoleManager.showConsoleView((IConsole)this.console);
        }
        Runtime runtime = Runtime.getRuntime();
        String[] args = this.toArgs(input, output, setting, inputSetting);
        String command = "";
        int i = 0;
        while (i < args.length) {
            command = String.valueOf(command) + this.toArg(args[i]) + " ";
            ++i;
        }
        System.out.println(command);
        File pathFile = new File(this.getFFMpegPath());
        Process process = runtime.exec(args, null, pathFile.getParentFile());
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        Color defaultColor = new Color(null, 0, 0, 0);
        Color errorColor = new Color(null, 255, 0, 0);
        this.errorStream.setColor(errorColor);
        this.consoleStream.setColor(defaultColor);
        this.progressStream.setColor(new Color(null, 0, 0, 255));
        while ((errorLine = errorReader.readLine()) != null) {
            if (this.isError(errorLine)) {
                this.errorStream.println(errorLine);
                continue;
            }
            if (this.isProgress(errorLine)) {
                this.progressStream.println(errorLine);
                continue;
            }
            this.consoleStream.println(errorLine);
        }
        errorReader.close();
    }

    public boolean isProgress(String line) {
        return line.startsWith("size=");
    }

    public boolean isError(String line) {
        if (line.indexOf("is not allowed in mp2") != -1) {
            return true;
        }
        if (line.indexOf(">Error") != -1) {
            return true;
        }
        if (line.indexOf("11024 Hz") != -1) {
            return true;
        }
        if (line.indexOf("22049 Hz") != -1) {
            return true;
        }
        return line.indexOf("44099 Hz") != -1;
    }

    public String toArg(String text) {
        if (text.indexOf(" ") != -1) {
            return "\"" + text + "\"";
        }
        return text;
    }

    public String getName() {
        return "FFMpeg";
    }
}

