/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.snack;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.jpn.xucker.snack.Formant;

public class FormantFigure
extends Figure {
    public static Log log;
    private double formantFrameMilliSecond = 10.0;
    private final double basePPS = 5.0;
    Formant[] formants;
    private int drawHeight = 512;
    private int maxHeltz = 24000;
    private int sampleRate;
    private double wzoom = 1.0;
    private double viewpps = 5.0 * this.wzoom;
    private boolean fit;
    private int marginY;
    private int marginX;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.snack.FormantFigure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public double getWzoom() {
        return this.wzoom;
    }

    public void setWzoom(double wzoom) {
        this.wzoom = wzoom;
        this.viewpps = 5.0 / wzoom;
        this.resize();
    }

    public boolean isFit() {
        return this.fit;
    }

    public void setFit(boolean fit) {
        this.fit = fit;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void resize() {
        if (this.formants != null) {
            this.setSize((int)((double)this.formants.length * (this.formantFrameMilliSecond / this.viewpps)), this.drawHeight);
        }
    }

    public int getMarginX() {
        return this.marginX;
    }

    public void setMarginX(int marginX) {
        this.marginX = marginX;
    }

    public int getMarginY() {
        return this.marginY;
    }

    public void setMarginY(int marginY) {
        this.marginY = marginY;
    }

    private int toYLocation(double value) {
        if (this.fit) {
            return this.drawHeight - (int)((double)(this.drawHeight - this.marginY * 2) * (value / (double)(this.sampleRate / 2)));
        }
        return this.drawHeight - (int)((double)(this.drawHeight - this.marginY * 2) * (value / (double)this.maxHeltz));
    }

    public void paintFigure(Graphics g) {
        log.trace((Object)"paintFigure");
        Color[] fColor = new Color[]{new Color(null, 255, 0, 0), new Color(null, 0, 255, 0), new Color(null, 0, 0, 255)};
        Point[] preF = new Point[3];
        if (this.formants != null) {
            double resize = this.formantFrameMilliSecond / this.viewpps;
            System.out.println("resize:" + resize);
            int i = 0;
            while (i < this.formants.length) {
                int j = 0;
                while (j < 3) {
                    double f = j == 0 ? this.formants[i].getF1() : (j == 1 ? this.formants[i].getF2() : this.formants[i].getF3());
                    Point currentF = new Point((double)this.marginX * this.wzoom + (double)((int)((double)i * resize)), (double)(this.marginY + this.toYLocation(f)));
                    g.setForegroundColor(fColor[j]);
                    if (preF[j] != null) {
                        g.drawLine(preF[j], currentF);
                    } else {
                        g.drawLine(currentF, currentF);
                    }
                    preF[j] = currentF;
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setFormants(Formant[] formants) {
        this.formants = formants;
    }
}

