/*
 * Decompiled with CFR 0.152.
 */
package oggrcp;

import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class OggrcpPlugin
extends AbstractUIPlugin {
    private static OggrcpPlugin plugin;
    private ResourceBundle resourceBundle;

    public OggrcpPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("oggrcp.OggrcpPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static OggrcpPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = OggrcpPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public File getOGGDecFile() {
        return new File(this.getVorbistoolsDirectory(), this.getOSExecuteName("oggdec"));
    }

    public File getOGGEncFile() {
        return new File(this.getVorbistoolsDirectory(), this.getOSExecuteName("oggenc"));
    }

    public File getVorbistoolsDirectory() {
        File file = new File(this.toPluginDir(this), "vorbis-tools");
        return file;
    }

    public String getOSExecuteName(String base) {
        if (Platform.getOS().equals("win32")) {
            return String.valueOf(base) + ".exe";
        }
        return base;
    }

    private File toPluginDir(AbstractUIPlugin plugin) {
        return new File(Platform.getInstallLocation().getURL().getPath(), "plugins/" + plugin.getBundle().getSymbolicName() + "_" + plugin.getBundle().getHeaders().get("Bundle-Version"));
    }
}

