package org.jpn.xucker.rcp.audiotools;


import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;




public class AudioToolsWorkbenchAdvisor extends WorkbenchAdvisor {

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
		configurer.setSaveAndRestore(false);
	}
    
    public String getInitialWindowPerspectiveId() {
        return AudioToolsPerspective.ID;
    }
    
    public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
       
        
        super.preWindowOpen(configurer);
        
        configurer.setInitialSize(new Point(640, 740));
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowPerspectiveBar(false);
        configurer.setShowFastViewBars(true);
        configurer.setShowMenuBar(true);
        
        
       
        
        
    }
    public class tmp extends Action{
        
    }
    
    
    public void postWindowOpen(IWorkbenchWindowConfigurer configurer) {
        AudioToolsPlugin.getDefault().init();
       
        
	}
    
    
    public void fillActionBars(
    	    IWorkbenchWindow window,
    	    IActionBarConfigurer configurer,
    	    int flags) {
    	    super.fillActionBars(window, configurer, flags);
             if ((flags & FILL_MENU_BAR) != 0) {
    	        fillMenuBar(window, configurer);
    	    }
    	}
    
    
    private void fillMenuBar(
    	    IWorkbenchWindow window,
    	    IActionBarConfigurer configurer) {
    	    IMenuManager menuBar = configurer.getMenuManager();
    	  
    	    menuBar.add(createFileMenu(window));
    	    menuBar.add(createWindowMenu(window));
    	    menuBar.add(createHelpMenu(window));
    	}
    
    
    private MenuManager createHelpMenu(IWorkbenchWindow window) {
        
         //System.out.println(IWorkbenchActionConstants.HELP_START);
         	    MenuManager menu = new MenuManager(Messages.getString("help"), //$NON-NLS-1$
         	        "myhelp"); //if add other basic plugin.should change it.
         	    menu.add(new GroupMarker(IWorkbenchActionConstants.HELP_START));
         	   
         	    IWorkbenchAction action=ActionFactory.ABOUT.create(window);
         	   
         	   
         	    menu.add(action);
         	   
         	    menu.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
         	   
         	    menu.add(new GroupMarker(IWorkbenchActionConstants.HELP_END));
         	    
         	    return menu;
         	}
    private MenuManager createWindowMenu(IWorkbenchWindow window) {
        
        
         	    MenuManager menu = new MenuManager(Messages.getString("window"), 
         	        IWorkbenchActionConstants.M_WINDOW);
         	   
         	    IWorkbenchAction action=
         	   ActionFactory.PREFERENCES.create(window);
         	   action.setText(Messages.getString("preferences"));
         	   menu.add(action);
         	   
         	 
         	    
         	    return menu;
         	}
    
    private MenuManager createFileMenu(IWorkbenchWindow window) {
        
        
         	    MenuManager menu = new MenuManager(Messages.getString("file"), 
         	        "myfile");
         	   
         	    IWorkbenchAction action=
         	   ActionFactory.QUIT.create(window);
         	   action.setText(Messages.getString("quit")); 
         	   menu.add(action);
         	   
         	 
         	    
         	    return menu;
         	}

    
}