/*
 * Created on 2005/04/07
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.oggtools;

import oggrcp.OggrcpPlugin;

import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.audio.AudioConverter;
import org.jpn.xucker.rcp.audio.AudioSetting;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;
import org.jpn.xucker.rcp.audiotools.spectrogram.views.AudioGraphView;
import org.jpn.xucker.rcp.audiotools.tools.ToolsUtil;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * 
 *
 */
public class OggTools implements AudioConverter{
    public static Log log = LogFactory.getLog(OggTools.class);

    public static IConsoleManager consoleManager;
    private MessageConsoleStream consoleStream;
    private MessageConsoleStream errorStream;
    private MessageConsoleStream progressStream;

    private MessageConsole console;
    /* (non-Javadoc)
     * @see org.jpn.xucker.rcp.audiotools.AudioTool#canConvert(java.lang.String, java.lang.String)
     */
    public boolean canConvert(String input, String output) {
       // log.trace("can convert:"+input+","+output);
        if(input.equals(AudioConverter.WAV) && output.equals(AudioConverter.OGG)){
			return true;
		}
		if(input.equals(AudioConverter.OGG) && output.equals(AudioConverter.WAV)){
			return true;
		}
		return false;
    }

    
    private String getEncoderPath(){
        return OggrcpPlugin.getDefault().getOGGEncFile().getAbsolutePath();
    }
    
    private String getDecoderPath(){
        return OggrcpPlugin.getDefault().getOGGDecFile().getAbsolutePath();
    }

    /* (non-Javadoc)
     * @see org.jpn.xucker.rcp.audiotools.AudioTool#convert(java.io.File, java.io.File)
     */
    
    public String[] toDecodeArgs(File input,File output,AudioSetting setting,AudioSetting inputSetting){
      
      List argList=new ArrayList();
      argList.add(getDecoderPath());
      
      
          //System.out.println(""+setting.getBitrate()+","+setting.getSamplerate()+","+setting.getSamplebit()+","+setting.getChannel());
      String inputExtension=ToolsUtil.getExtension(input.getName());    
      String outputExtension=ToolsUtil.getExtension(output.getName());
      if(!outputExtension.equals(AudioConverter.WAV)){
          throw new RuntimeException("current support wav only");
      }
          
              if(setting!=null){
              if(setting.getSamplebit()==16){
                  argList.add("-b");
                  argList.add("16");
              }else if(setting.getSamplebit()==8){
                  argList.add("-b");
                  argList.add("8");
                  argList.add("-s");
                  argList.add("0");//signed
              }
              
              
              }else{
                  
              }
          
          
      argList.add(input.getAbsolutePath());
      
      argList.add("-o");
      argList.add(output.getAbsolutePath());
      
      return (String[])argList.toArray(new String[argList.size()]);
    }
    
    
    public String[] toEncodeArgs(File input,File output,AudioSetting setting,AudioSetting inputSetting){
        
        List argList=new ArrayList();
        argList.add(getEncoderPath());
        
        
            //System.out.println(""+setting.getBitrate()+","+setting.getSamplerate()+","+setting.getSamplebit()+","+setting.getChannel());
        String inputExtension=ToolsUtil.getExtension(input.getName());    
        String outputExtension=ToolsUtil.getExtension(output.getName());
        if(!inputExtension.equals(AudioConverter.WAV)){
            throw new RuntimeException("current support wav only");
        }
            
                if(setting!=null){
                
                    /*
                     * TODO support channel.
                    if(inputSetting.getChannel()!=setting.getChannel()){
                        if(inputSetting.getChannel()==2){
                            argList.add("--downmix");
                            
                        }else{
                            
                        errorStream.println("sorry I can't chage mono to stereo channel yet.");
                        }
                    }*/
                    
                    if(inputSetting.getSamplerate()!=setting.getSamplerate()){
                        argList.add("--resample");
                        argList.add(""+setting.getSamplerate());
                    }
                    
                    
                    if(setting.getBitrate()>0){
                        //argList.add("-b");
                        argList.add("-M");
                        argList.add(""+setting.getBitrate()/1000);
                    }
                    
                
                }
            
            
        argList.add(input.getAbsolutePath());
        
        argList.add("-o");
        argList.add(output.getAbsolutePath());
        
        return (String[])argList.toArray(new String[argList.size()]);
      }
    
    public void convert(File input, File output,AudioSetting setting,AudioSetting inputSetting) throws IOException {
        if(consoleManager==null){
            consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            console = new MessageConsole(getName(), null);
            consoleManager.addConsoles(new IConsole[] {console});
            consoleStream = console.newMessageStream();
            errorStream = console.newMessageStream();
            progressStream = console.newMessageStream();
            
            Color defaultColor=new Color(null,0,0,0);
            Color errorColor=new Color(null,255,0,0);
            errorStream.setColor(errorColor);
            consoleStream.setColor(defaultColor);
            progressStream.setColor(new Color(null,0,0,255));
        }else{
            consoleManager.showConsoleView(console);
        }
        
        
        
        Runtime runtime=Runtime.getRuntime();
        String args[]=null;
        
        if(ToolsUtil.getExtension(input).equals(AudioConverter.WAV)){
            args=toEncodeArgs(input,output,setting,inputSetting);
        }else{
            args=toDecodeArgs(input,output,setting,inputSetting);
        }
        
        
       
        //String args[]=new String[]{getFFMpegPath(),"-y","-i",input.getAbsolutePath(),output.getAbsolutePath()};
        
        //String args[]=new String[]{"C:\\Program Files\\MediaInfo_Cmd_Win32_0.4.0.0\\mediainfo",input.getAbsolutePath()};
        String command="";
        for (int i = 0; i < args.length; i++) {
            command+=toArg(args[i])+" ";
        }
        consoleStream.println(command);
       
       
       
       File pathFile=new File(getEncoderPath());
       
        
        Process process=runtime.exec(args,null,pathFile.getParentFile());
        
        int c;
        String line;
        InputStream in=null;
        
        
        
       
        
        
       /*
        InputStream in=process.getInputStream();
        while((c=in.read())!=-1){
            consoleStream.print(""+(char)c);
        }*/
        
        
        
        
        //consoleStream.println(command);
        /*
        PrintStream pout=new PrintStream(process.getOutputStream());
        //pout.println(""+toArg(getFFMpegPath())+" -formats");
      // pout.println("echo %path%");
      // pout.println("ffmpeg -formats");
       
        pout.println(command);
        
        pout.close();
        */
        
        String errorLine;
        BufferedReader errorReader=new BufferedReader(new InputStreamReader(process.getErrorStream()));
      
        while((errorLine=errorReader.readLine())!=null){
            if(isError(errorLine)){
                errorStream.println(errorLine);
            }else if(isProgress(errorLine)){
                progressStream.println(errorLine);
            }else{
                consoleStream.println(errorLine);
            }
        }
        
        errorReader.close();
        
       
        BufferedReader reader=new BufferedReader(new InputStreamReader(process.getInputStream()));
        while((line=reader.readLine())!=null){
            if(isError(line)){ 
                errorStream.println(line);
            }else if(isProgress(line)){
                progressStream.println(line);
            }else{
                consoleStream.println(line);
            }
        }
        
        reader.close();
       
        
       
        
        
       
        /*
        try {
            process.waitFor();
        } catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }*/
        
        
        
        
        
        /*
        in=process.getInputStream();
        while((c=in.read())!=-1){
            consoleStream.print(""+(char)c);
        }*/
        
        
      
        
        
        
    }
    public boolean isProgress(String line){
        return line.indexOf("remaining]")!=-1 || line.indexOf("%]")!=-1 || line.indexOf("Done encoding file")!=-1 ;
        
    }
    public boolean isError(String line){
        /*
        if(line.indexOf("is not allowed in mp2")!=-1){
            return true;
        }else if(line.indexOf(">Error")!=-1){
            return true;
        }else if(line.indexOf("11024 Hz")!=-1){
            return true;
        }else if(line.indexOf("22049 Hz")!=-1){
            return true;
        }else if(line.indexOf("44099 Hz")!=-1){
            return true;
        }*/
        
        if(line.indexOf("Mode initialisation failed: invalid parameters for bitrate")!=-1){
        return true;    
        }
		
        return false;
    }

  
    //TODO abstract
    private String toArg(String text){
        if(text.indexOf(" ")!=-1){
            return "\""+text+"\"";
        }else{
            return text;
        }
    }
    
    public String getName(){
        return "OggTools";
    }
}
