/*
 * Created on 2005/04/30
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.spectrogram;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.snack.FormantFigure;

/**
 * 
 *
 */
public class SpectrogramImageFigure extends Figure{
    public static Log log = LogFactory.getLog(SpectrogramImageFigure.class);
private int samplerate=48000;
public static final int MAX_SAMPLERATE=48000;
private int baseHeight=512;
private boolean fit;
private double vzoom=1;
private double wzoom=1;
private Image spectrogramImage;

public int getBaseHeight() {
    return baseHeight;
}
public void setBaseHeight(int baseHeight) {
    this.baseHeight = baseHeight;
}
public boolean isFit() {
    return fit;
}
public void setFit(boolean fit) {
    this.fit = fit;
}
public int getSamplerate() {
    return samplerate;
}
public void setSamplerate(int samplerate) {
    this.samplerate = samplerate;
}
public Image getSpectrogramImage() {
    return spectrogramImage;
}
public void setSpectrogramImage(Image spectrogramImage) {
    this.spectrogramImage = spectrogramImage;
    setZoom(wzoom,vzoom);
}
public double getVzoom() {
    return vzoom;
}
public void setVzoom(double vzoom) {
    this.vzoom = vzoom;
}
public double getWzoom() {
    return wzoom;
}
public void setWzoom(double wzoom) {
    this.wzoom = wzoom;
}
public void setZoom(double w,double v){
    wzoom=w;
    vzoom=v;
    if(spectrogramImage!=null && !spectrogramImage.isDisposed()){
    setSize((int)(spectrogramImage.getBounds().width*wzoom),(int)(baseHeight*vzoom));
    }
}

public void paintFigure(Graphics g){
    log.trace("paintFigure");
    Rectangle clientArea = getClientArea();
    
   // System.out.println(this.getClientArea());
 //   System.out.println(this.getSize());
    
    if(spectrogramImage!=null && !spectrogramImage.isDisposed()){
         
        if(fit){
            g.drawImage(spectrogramImage,0,0,spectrogramImage.getBounds().width,spectrogramImage.getBounds().height,clientArea.x,clientArea.y,this.getSize().width,this.getSize().height);
                
        }else{
            int drawHeight=(int)(samplerate*baseHeight*vzoom/MAX_SAMPLERATE);
           // System.out.println(drawHeight);
            g.drawImage(spectrogramImage,0,0,spectrogramImage.getBounds().width,spectrogramImage.getBounds().height,clientArea.x,clientArea.y+clientArea.height-drawHeight,this.getSize().width,drawHeight);
        }
        }
    }
}
