/*
 * Created on 2005/04/07
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.spectrogram.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.audio.AudioConverter;
import org.jpn.xucker.rcp.audiotools.QuickConverter;
import org.jpn.xucker.rcp.audiotools.spectrogram.SpectrogramImageFigure;
import org.jpn.xucker.rcp.audiotools.spectrogram.SpectrogramPainter;
import org.jpn.xucker.rcp.audiotools.tools.ToolsUtil;
import org.jpn.xucker.rcp.snack.Snack_rcpPlugin;
import org.jpn.xucker.rcp.ui.BufferedImagePainter;

import org.jpn.xucker.rcp.ui.DefaultZoom;
import org.jpn.xucker.rcp.ui.FigureMemoryComposite;
import org.jpn.xucker.rcp.ui.NumberLabelProvider;
import org.jpn.xucker.rcp.ui.SimpleGraphMemoryPainter;
import org.jpn.xucker.rcp.ui.Zoom;
import org.jpn.xucker.rcp.ui.ZoomChangeListener;
import org.jpn.xucker.snack.Formant;
import org.jpn.xucker.snack.FormantFigure;
import org.jpn.xucker.snack.FormantParser;

import org.jpn.xucker.snack.SnackExecuter;
import org.jpn.xucker.snack.Spectrogram;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

import java.awt.Graphics;
import java.awt.image.BufferedImage;

/**
 * 
 *  
 */
public class AudioGraphView extends ViewPart {
    public static Log log = LogFactory.getLog(AudioGraphView.class);

    public static String ID_VIEW = AudioGraphView.class.getName();

    private SnackExecuter snackExecuter;

    private FigureMemoryComposite imageMemoryComposite;

    private SpectrogramPainter painter;

    //private ResizableImageFigure resizableImageFigure;
    private SpectrogramImageFigure spectrogramImageFigure;

    private FormantFigure formantFigure = new FormantFigure();

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */

    int compositeHeight = 512;

    
    
    int basePersecond=400;
    
    DefaultZoom defaultZoom=new DefaultZoom();

    double pixelMillisecond = 2.5;

    private KHZMemoryPainter khzMemoryPainter;

    private boolean spectrogram;

    private boolean formant = true;

    private int graphTop = 24;

    private int graphLeft = 46;

    public boolean isFormant() {
        return formant;
    }

    public void setFormant(boolean formant) {
        log.trace("formant:" + formant);
        this.formant = formant;
        formantFigure.setVisible(formant);
    }

    public boolean isSpectrogram() {
        return spectrogram;
    }

    public void setSpectrogram(boolean spectrogram) {
        this.spectrogram = spectrogram;
    }

    public class ZoomChangeRepaint implements ZoomChangeListener{

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.ZoomChangeListener#zoomUp(org.jpn.xucker.rcp.ui.Zoom)
         */
        public void zoomUp(Zoom arg0) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.ZoomChangeListener#zoomDown(org.jpn.xucker.rcp.ui.Zoom)
         */
        public void zoomDown(Zoom arg0) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.ZoomChangeListener#zoomChange(org.jpn.xucker.rcp.ui.Zoom)
         */
        public void zoomChange(Zoom zoom) {
            // TODO Auto-generated method stub
            setHorizontalMemoryValue();
            spectrogramImageFigure.setZoom(zoom.getZoom(), 1);
            formantFigure.setWzoom(zoom.getZoom());
            updateDraw();
        }
        
    }
    public void createPartControl(Composite parent) {
        snackExecuter = new SnackExecuter(Snack_rcpPlugin.getDefault()
                .getSnackExecuterDirectory().getAbsolutePath());
        imageMemoryComposite = new FigureMemoryComposite(parent, SWT.NULL,
                graphTop, graphLeft);

        painter = new SpectrogramPainter(parent.getDisplay());

        SimpleGraphMemoryPainter vpainter = imageMemoryComposite
                .getVerticalGraphPainter();

        vpainter.setPerMain((double) compositeHeight / 12);
        //System.out.println(vpainter.getPerMain());
        vpainter.setGraphPlus(true);

        khzMemoryPainter = new KHZMemoryPainter();
        khzMemoryPainter.setHeight(compositeHeight);
        khzMemoryPainter.setGraphPlus(false);
        khzMemoryPainter.setVerticalGraph(true);
        imageMemoryComposite.setMaxVerticalValue(compositeHeight);
        imageMemoryComposite.setVerticalMemoryStart(compositeHeight - 1);//move
                                                                         // 1
                                                                         // pixel.TODO

        imageMemoryComposite.setVscrollLabelProvider(khzMemoryPainter);//TODO
                                                                       // not
                                                                       // support
                                                                       // zoom.
        imageMemoryComposite.getVerticalMemoryCanvas().setGraphMemoryPainter(
                khzMemoryPainter);
        //imageMemoryComposite.setMaxVerticalValue((int)(vpainter.getPerMain()*12));
        imageMemoryComposite.getHorizontalGraphPainter().setPerMain(80);//1000ms == 400pixe;
        setHorizontalMemoryValue();

        spectrogramImageFigure = new SpectrogramImageFigure();
        
        imageMemoryComposite.getContents().add(spectrogramImageFigure);

        spectrogramImageFigure.setZoom(defaultZoom.getZoom(), 1);
        spectrogramImageFigure.add(formantFigure);//TODO change layer.

        //setAudio(new File("c:\\tmp\\aiueo.wav"));
        //setAudio(new File("c:\\tmp\\_theend.wav"));
        //setAudio(new File("c:\\tmp\\aiueo.wav"));
       setFit(true);
       
        defaultZoom.setWrap(true);
        defaultZoom.addZoomChangeListener(new ZoomChangeRepaint());
        defaultZoom.setZoomIndex(4);//2.0;
        MouseZoom mouseListener=new MouseZoom();
        //imageMemoryComposite.getScalableLayeredPane().addMouseListener(mouseListener);
        imageMemoryComposite.getCanvas().addMouseListener(mouseListener);
        
        
        Transfer[] types = new Transfer[] {FileTransfer.getInstance()};
    	
    	int operations = DND.DROP_MOVE | DND.DROP_COPY ;
    	
    	
    		
    	
    	
    	
    	
    		DropTarget target2 = new DropTarget (imageMemoryComposite.getCanvas(), operations);
    		target2.setTransfer(types);
    	
    		target2.addDropListener(new DropMonitor());
       }
    
    public class DropMonitor extends DropTargetAdapter{
		public void dragEnter(DropTargetEvent event){
			//System.out.println("drag enter:"+event.data);
		}
		public void dragOver(DropTargetEvent event){
			//System.out.println("drag over:"+event.data);
			}
		public void drop(DropTargetEvent event){
			//System.out.println("drop:"+event.data);
			
			//System.out.println(event.data.getClass().getName());
			String files[]=(String[])event.data;
		
		
			for(int i=0;i<files.length;i++){
				setAudio(new File(files[0]));
				break;
			}
			
			}
	}
    
    public class MouseZoom implements MouseListener,org.eclipse.swt.events.MouseListener{

       

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mousePressed(org.eclipse.draw2d.MouseEvent)
         */
        public void mousePressed(org.eclipse.draw2d.MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseReleased(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseReleased(org.eclipse.draw2d.MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseDoubleClicked(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseDoubleClicked(org.eclipse.draw2d.MouseEvent arg0) {
            //System.out.println("zoom");
            defaultZoom.zoomUp();
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.MouseListener#mouseDoubleClick(org.eclipse.swt.events.MouseEvent)
         */
        public void mouseDoubleClick(MouseEvent e) {
            //System.out.println("canvas:zoom");
            defaultZoom.zoomUp();
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.MouseListener#mouseDown(org.eclipse.swt.events.MouseEvent)
         */
        public void mouseDown(MouseEvent e) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.MouseListener#mouseUp(org.eclipse.swt.events.MouseEvent)
         */
        public void mouseUp(MouseEvent e) {
            // TODO Auto-generated method stub
            
        }
        
    }
    public void setHorizontalMemoryValue(){
        imageMemoryComposite.setHscrollLabelProvider(new NumberLabelProvider(
                (int)(basePersecond/defaultZoom.getZoom()), 4 * 60 * 20));
    }
    

    

    public IProgressMonitor getProgressMonitor(){
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
IStatusLineManager lineManager = workbenchWindow.getStatusLineManager();
return lineManager.getProgressMonitor();
}
    
    
    
    public class ExportImage extends Thread implements org.jpn.xucker.rcp.ui.ProgressMonitor{
        private File file;
        private Shell shell;
        
        private IProgressMonitor monitor;
        int maxprogress;
        //int currentprogress;
        
        public ExportImage(Shell shell,File file){
            this.file=file;
            this.shell=shell;
            monitor=getProgressMonitor();
            maxprogress=(int)(compositeHeight/50*1.2);//TODO zoom?
            monitor.beginTask("Export Image:"+file.getAbsolutePath(),maxprogress);
        }
        
        public void run(){
        //disable action.
            
           
            doExportImage(shell,file);
            shell.getDisplay().asyncExec(new MonitorDone());
        //enable action.
        }
        

        public void doExportImage(Shell shell,File file){
            //System.out.println(shell+","+shell.getDisplay());
            if(spectrogramImageFigure.getSpectrogramImage()!=null){
            BufferedImage bufferedImage = new BufferedImage((int)(
                    spectrogramImageFigure.getSpectrogramImage().getBounds().width
                            * defaultZoom.getZoom() + graphLeft), compositeHeight + graphTop,BufferedImage.TYPE_INT_ARGB);
            //drop left/top corner.
            Graphics g=bufferedImage.getGraphics();
            g.setColor(java.awt.Color.white);
            g.fillRect(0,0,graphLeft,graphTop);
            
            
            Image spectrogram = new Image(
                    shell.getDisplay(),
                            (int)(spectrogramImageFigure.getSpectrogramImage().getBounds().width * defaultZoom.getZoom()),
                    compositeHeight);
           
            SWTGraphics graphics = new SWTGraphics(new GC(spectrogram));
            spectrogramImageFigure.paint(graphics);
            
           BufferedImagePainter painter=new BufferedImagePainter();
           painter.setMonitor(this);
            
            
           painter.drawAtBufferedImage(bufferedImage,spectrogram, graphLeft, graphTop);
            spectrogram.dispose();
            graphics.dispose();
            
            //
            Image verticalImage=new Image(
                    shell.getDisplay(),
                    graphLeft,
                    compositeHeight);
            GC verticalGC=new GC(verticalImage);
            imageMemoryComposite.getVerticalGraphPainter().draw(verticalGC, graphLeft-1,
                    compositeHeight,compositeHeight );
            painter.drawAtBufferedImage(bufferedImage,verticalImage, 0, graphTop);
            verticalImage.dispose();
            verticalGC.dispose();
            
            //
            Image horizontalImage=new Image(
                    shell
                            .getDisplay(),
                            (int)( spectrogramImageFigure.getSpectrogramImage().getBounds().width * defaultZoom.getZoom()),
                    graphTop);
            GC horizontalGC=new GC(horizontalImage);
            imageMemoryComposite.getHorizontalGraphPainter().draw(horizontalGC, 0,
                    graphTop-1,(int)(spectrogramImageFigure.getSpectrogramImage().getBounds().width * defaultZoom.getZoom()));
            
            painter.drawAtBufferedImage(bufferedImage,horizontalImage, graphLeft, 0); 
            horizontalImage.dispose();
            horizontalGC.dispose();
            
            
           
            
            try {
                ImageIO.write(bufferedImage,"png",file);
                /*
                imageMemoryComposite.getHorizontalGraphPainter()
                        .draw(
                                imgGC,
                                graphLeft,
                                graphTop,
                                spectrogramImageFigure.getSpectrogramImage()
                                        .getBounds().width * widthZoom);
                                        */
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            
            
            bufferedImage=null;
            System.gc();//IMPORTANT
          
            
            
            }
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.BufferedImagePainterMonitor#finished(int)
         */
        public void worked(int arg0) {
           // currentprogress++;
            shell.getDisplay().asyncExec(new MonitorWork());
        }
        public boolean isCanceled(){
            return monitor.isCanceled();
        }
        public class MonitorDone extends Thread{
            public void run(){
                monitor.done();
            }
        }
        public class MonitorWork extends Thread{
            public void run(){
                monitor.worked(1);
            }
        }
    }
    
   
    
    public void exportImage(File file) {
        //System.out.println("exp:"+PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        ExportImage exp=new ExportImage(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
                ,file);
        exp.start();
    }
    

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
     */
    public void setFocus() {
      
    }

    private boolean fit = true;

    private int samplerate = 48000;//default

    public void setFit(boolean bool) {
        log.trace("fit:" + bool);
        formantFigure.setFit(bool);
        //spectrogramFigure.setFit(bool);
        spectrogramImageFigure.setFit(bool);
        if (bool) {
            khzMemoryPainter.setSamplerate(samplerate);//change memorysize.
        } else {
            khzMemoryPainter.setSamplerate(48000);//MAX samplerate.
        }
        //imageMemoryComposite.layout();
        updateDraw();
    }

    public void updateDraw(){
        imageMemoryComposite.getScalableLayeredPane().setScale(1.0);
        imageMemoryComposite.redraw(0, 0,
                imageMemoryComposite.getClientArea().width,
                imageMemoryComposite.getClientArea().height, true);
        
        log.trace("spectrogram:"+spectrogramImageFigure.getSize());
        log.trace("formant:"+formantFigure.getSize());
        //imageMemoryComposite.layout(true);
    }

    public class SetAudioData extends Thread{
        Formant[] formants;
        Image spectrogramImage;
        Spectrogram spectrogram;
        public SetAudioData(Spectrogram spectrogram,Image spectrogramImage,Formant[] formants){
            this.spectrogram=spectrogram;
            this.spectrogramImage=spectrogramImage;
            this.formants=formants;
        }
        public void run(){
            setAudioData(spectrogram,spectrogramImage,formants);
        }
    }
    
    public void setAudioData(Spectrogram spectrogram,Image spectrogramImage,Formant[] formants){
        /*
         * FormantParser parser=new FormantParser(); List
         * list=(List)parser.parse(new File("c:\\tmp\\f.txt")); Formant[]
         * formants=(Formant[])list.toArray(new
         * Formant[list.size()]);//test.
         */
        
        spectrogramImageFigure.setSpectrogramImage(spectrogramImage);
        spectrogramImageFigure.setSamplerate(samplerate);
        
        
        FormantParser.normalize(formants, 2);
        formantFigure.setFormants(formants);

        log.trace("formant-resize:");
        formantFigure.resize();
        formantFigure.setSampleRate(samplerate);
        //System.out.println("formants.lengt:"+formants.length);
        // System.out.println(spectrogram.toMillisecond()+","+Formant.toMillisecond(formants));

        int margin = (int) ((spectrogram.toMillisecond() - Formant
                .toMillisecond(formants))
                / pixelMillisecond / 2);
        //System.out.println(margin);
        formantFigure.setMarginX(margin);

        
        updateDraw();
    }
    public class OpenSpectrogram implements IRunnableWithProgress,org.jpn.xucker.rcp.ui.ProgressMonitor{
        File file;
        Shell shell;
        IProgressMonitor monitor;
        public OpenSpectrogram(Shell shell,File file){
            this.file=file;
            this.shell=shell;
        }
        /* (non-Javadoc)
         * @see org.eclipse.jface.operation.IRunnableWithProgress#run(org.eclipse.core.runtime.IProgressMonitor)
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.monitor=monitor;
            int ms=(100 * 2);//0.020 millisecond
            int step=0;
            try {
                AudioInputStream input=AudioSystem.getAudioInputStream(file);
                AudioFormat format=input.getFormat();
                samplerate=(int)format.getSampleRate();
                step=(int)(input.getFrameLength()/(samplerate/ms));
                log.trace("framesize:"+input.getFrameLength()+",samplerate="+samplerate+" ms="+ms);
            } catch (UnsupportedAudioFileException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            } catch (IOException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
            
           // samplerate = format.
            int persample = samplerate / ms;
            
            monitor.beginTask("Open File "+file.getAbsolutePath(),step*2);//parse and paint.
            //System.out.println("step:"+step*2);
         //   int step=samplerate*audioDuration
            try {

                if (spectrogramImageFigure.getSpectrogramImage() != null && !spectrogramImageFigure.getSpectrogramImage().isDisposed()) {
                    spectrogramImageFigure.getSpectrogramImage().dispose();
                }

                if (fit) {
                    khzMemoryPainter.setSamplerate(samplerate);//change memorysize.
                }

                Spectrogram spectrogram = snackExecuter.getSpectram(file
                        .getAbsolutePath(), samplerate, 512, persample, 0, 0,this);
                
                if(monitor.isCanceled()){
                    
                    return;
                }
                
                //System.out.println("sp:"+spectrogram.getWidth());
                
                
                
                
                
                //System.out.println("base:"+baseSpectrogramImage.getBounds());
                
                //resizableImageFigure.setSize(baseSpectrogramImage.getBounds().width*2,baseSpectrogramImage.getBounds().height);

                Formant[] formants = snackExecuter.getFormants(file
                        .getAbsolutePath());
                
                painter.setMonitor(this);
                Image baseSpectrogramImage = painter.createImage(spectrogram);
                
                if(monitor.isCanceled()){
                    
                    return;
                }
                monitor.done();
                
                if(spectrogram!=null && baseSpectrogramImage!=null && formants!=null){
                shell.getDisplay().syncExec(new SetAudioData(spectrogram,baseSpectrogramImage,formants));
                }else{
                    log.debug("SetAudioData:something null");
                }
               // imageMemoryComposite.getScalableLayeredPane().setScale(1.0);//Dont'
                                                                            // Use
                                                                            // pack();

                //redraw only over only.i don't know how to avoid that.
                //imageMemoryComposite.getHorizontalMemoryCanvas().redraw(0,0,imageMemoryComposite.getHorizontalMemoryCanvas().getBounds().width,imageMemoryComposite.getHorizontalMemoryCanvas().getBounds().height,true);
                //imageMemoryComposite.layout();
                //imageMemoryComposite.update();
                //imageMemoryComposite.pack(true);

            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        /* (non-Javadoc)
         * @see org.jpn.xucker.snack.ProgressMonitor#finished(int)
         */
        public void worked(int v) {
           // System.out.println("finished "+v);
            monitor.worked(v);
        }
        
        public boolean isCanceled(){
            return monitor.isCanceled();
        }
        
    }
    public void setAudio(File file) {

        File importFile=null;
        
        if(isWavFile(file)){
            importFile=file;
        }else{
            QuickConverter converter=new QuickConverter();
            if(converter.canConvert(file,AudioConverter.WAV)){
                try {
                    importFile=File.createTempFile("tmp",".wav");
                    log.trace("convert:"+importFile.getAbsolutePath());
                    converter.convert(file,importFile);
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }
        if(importFile!=null){
        IRunnableWithProgress progress=new OpenSpectrogram(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),importFile);
        
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, progress);
        } catch (InvocationTargetException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        }else{
            log.warn("not supported file "+file.getAbsolutePath());
        }
    }

    /**
     * @param file
     * @return
     */
    private boolean isWavFile(File file) {
       return ToolsUtil.getExtension(file).toLowerCase().equals("wav");
    }
        
    

    //BufferedImage is ARGB;
    /*
    public static void drawAtBufferedImage(BufferedImage bimg,Image image,int x,int y){
        ImageData data=image.getImageData();
        int at=0;
        for(int j=0;j<image.getBounds().height;j++){
            for(int i=0;i<image.getBounds().width;i++){
            
            int r=0xff & data.data[at+2];
            int g=0xff & data.data[at+1];
            
            
            
            int b=0xff & data.data[at];
           
            bimg.setRGB(i+x,j+y,0xFF<<24 | r<<16 | g<<8 | b<<0);
            at+=4;
        }
        
       
        }*/
        /*
        for(int i=0;i<image.getBounds().width;i++){
          
            for(int j=0;j<image.getBounds().height;j++){
                int r=0xff & data.data[4*(j*image.getBounds().width+i)+2];
                int g=0xff & data.data[4*(j*image.getBounds().width+i)+1];
                
                
                
                int b=0xff & data.data[4*(j*image.getBounds().width+i)];
               
                bimg.setRGB(i+x,j+y,0xFF<<24 | r<<16 | g<<8 | b<<0);
                
            }
        }*/
        
    }
    /*
    public static BufferedImage convertRGB(Image img){
        BufferedImage bimg=new BufferedImage(img.getBounds().width,img.getBounds().height,BufferedImage.TYPE_INT_BGR);
        ImageData data=img.getImageData();
        for(int i=0;i<img.getBounds().width;i++){
            for(int j=0;j<img.getBounds().height;j++){
                bimg.setRGB(i,j,data.getPixel(i,j));
            }
        }
       return bimg;
    }*/
    

