/*
 * Created on 2005/05/01
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools;

import org.jpn.xucker.rcp.audio.AudioConverter;
import org.jpn.xucker.rcp.audio.AudioSetting;
import org.jpn.xucker.rcp.audiotools.tools.ToolsUtil;

import java.io.File;
import java.io.IOException;

/**
 * 
 *
 */
public class QuickConverter {

    public boolean canConvert(File inputFile,String outputType){
        
        AudioConverter[] converters=AudioToolsPlugin.getDefault().getAudioConverters();
        for(int i=0;i<converters.length;i++){
            if(converters[i].canConvert(ToolsUtil.getExtension(inputFile).toLowerCase(),outputType)){//TODO move ToolsUtil to AudioConverter?
            return true;
            }
        }
        return false;
    }
   
    public void convert(File input,File output,AudioSetting inputSetting,AudioSetting outputSetting) throws IOException{
        AudioConverter[] converters=AudioToolsPlugin.getDefault().getAudioConverters();
        for(int i=0;i<converters.length;i++){
            if(converters[i].canConvert(ToolsUtil.getExtension(input).toLowerCase(),ToolsUtil.getExtension(output).toLowerCase())){//TODO move ToolsUtil to AudioConverter?
                converters[i].convert(input,output,inputSetting,outputSetting);
                }
        }
    }
    
    public void convert(File input,File output) throws IOException{
        convert(input,output,null,null);
    }

}
