/*
 * Created on 2005/04/20
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.snack;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.ui.ProgressMonitor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * 
 *
 */
public class SnackExecuter {
public static final int ALL_RANGE=0;
private String pysnackExecuterDir;
private Process process;

public static Log log=LogFactory.getLog(SnackExecuter.class);
public SnackExecuter(String dir){
    pysnackExecuterDir=dir;
}

public static int getDefaultValue(){
    return -138;
}



public void cancel(){
    if(process!=null){
        process.destroy();
        process=null;
    }
}

public Formant[] getFormants(String path) throws IOException{
    List blist=new ArrayList();
    
    String pyPath=pysnackExecuterDir;
    if(!pyPath.endsWith(File.separator)){
        pyPath=pysnackExecuterDir+File.separator;
    }
    pyPath+="formant.exe";
    
    String argv[]={pyPath,path};
    log.trace("start:formant");
    process = Runtime.getRuntime().exec(argv);
    log.trace("end:formant");
    if(process!=null){
        InputStream stream=null;
        synchronized(this){
            if(process!=null){
                stream=process.getInputStream();
            }
        }
        
        if(stream!=null){
        FormantParser parser=new FormantParser();
        blist=(List)parser.parse(process.getInputStream());
        }

    }
    
    return (Formant[])blist.toArray(new Formant[0]);
}

public Spectrogram getSpectram(String path,int samplerate,int height,int persample,int start,int end) throws IOException{
return getSpectram(path,samplerate,height,persample,start,end,null)  ;
}
public Spectrogram getSpectram(String path,int samplerate,int height,int persample,int start,int end,ProgressMonitor monitor) throws IOException{

   
    Spectrogram spectrogram=null;
    String pyPath=pysnackExecuterDir;
    if(!pyPath.endsWith(File.separator)){
        pyPath=pysnackExecuterDir+File.separator;
    }
    pyPath+="spectram.exe";
    
    String argv[]={pyPath,path,""+height,""+persample,""+start,""+end};
    log.trace("start:getSpectoram");
    process = Runtime.getRuntime().exec(argv);
    log.trace("end:getSpectoram");
    if(process!=null){
        InputStream input=null;
        synchronized(this){
            if(process!=null){
            input=process.getInputStream();
            if(input!=null){
                long starttime=System.currentTimeMillis();
                log.trace("start-parse-spectrogram:");
                SpectrogramParser parser=new SpectrogramParser(samplerate,height,persample);
                parser.setProgressMonitor(monitor);
                spectrogram=(Spectrogram)parser.parse(input);
                log.trace("end-parse-spectrogram:"+(System.currentTimeMillis()-starttime)+"ms");
            }
            }
        }
    }
    return spectrogram;
    }

/*
    public double[] getSpectram(String path,int height,int persample,int start,int end) throws IOException{
        ArrayDoubleList blist=new ArrayDoubleList();
        
        String pyPath=pysnackExecuterDir;
        if(!pyPath.endsWith(File.separator)){
            pyPath=pysnackExecuterDir+File.separator;
        }
        pyPath+="spectram.exe";
        
        String argv[]={pyPath,path,""+height,""+persample,""+start,""+end};
        log.trace("start:getSpectoram");
        process = Runtime.getRuntime().exec(argv);
        log.trace("end:getSpectoram");
        if(process!=null){
            BufferedReader reader=null;
            synchronized(this){
                if(process!=null){
                reader=new BufferedReader(new InputStreamReader(process.getInputStream()));
                }
            }
            
        String line;
        if(reader!=null){
            log.trace("start:reading");
        while((line=reader.readLine())!=null){
            blist.add(Double.parseDouble(line));
        	}
        reader.close();
        log.trace("end:reading");
        }
        }
       
        return blist.toArray();
        }*/
    
}
