/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;

public class SenUtils {
    private static char separator = System.getProperty("file.separator").charAt(0);

    public static String getRealPath(String name) {
        String senHome = System.getProperty("sen.home");
        if (senHome == null) {
            return name;
        }
        return senHome + File.separatorChar + name;
    }

    public static char[] loadFile(String str) {
        char[] c = null;
        try {
            File f = new File(str);
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            int len = (int)f.length();
            c = new char[len];
            for (int i = 0; i < len; ++i) {
                int tmp = reader.read();
                c[i] = (char)tmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public static final int readBSInt(InputStream is) throws IOException {
        int i1 = is.read();
        int i2 = is.read();
        int i3 = is.read();
        int i4 = is.read();
        return i1 + (i2 << 8) + (i3 << 16) + (i4 << 24);
    }

    public static final int readBSInt(RandomAccessFile is) throws IOException {
        int i1 = is.read();
        int i2 = is.read();
        int i3 = is.read();
        int i4 = is.read();
        i1 = i1 >= 0 ? i1 : 256 + i1;
        i2 = i2 >= 0 ? i2 : 256 + i2;
        i3 = i3 >= 0 ? i3 : 256 + i3;
        i4 = i4 >= 0 ? i4 : 256 + i4;
        return i1 + (i2 << 8) + (i3 << 16) + (i4 << 24);
    }

    public static final short readBSShort(RandomAccessFile is) throws IOException {
        int i1 = is.read();
        int i2 = is.read();
        i1 = i1 >= 0 ? i1 : 256 + i1;
        i2 = i2 >= 0 ? i2 : 256 + i2;
        return (short)(i1 + (i2 << 8));
    }

    public static final short readShort(RandomAccessFile is) throws IOException {
        int i1 = is.read();
        int i2 = is.read();
        return (short)((i1 << 8) + i2);
    }

    public static String getPath(String path, String parent) {
        if (path.charAt(0) != separator || path.length() > 1 && path.charAt(1) == ':' && separator == '\\') {
            return parent + separator + path;
        }
        return path;
    }
}

