/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.java.sen.Token;
import net.java.sen.processor.PostProcessor;

public class CompositPostProcessor
implements PostProcessor {
    private List rules = new ArrayList();

    public void readRules(BufferedReader reader) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            if (!st.hasMoreTokens()) continue;
            HashSet<String> ruleSet = new HashSet<String>();
            String first = st.nextToken();
            if (!st.hasMoreTokens()) {
                this.removeFromOtherRules(first);
                ruleSet.add(first);
                this.rules.add(new Rule(first, ruleSet));
                continue;
            }
            while (st.hasMoreTokens()) {
                String pos = st.nextToken();
                this.removeFromOtherRules(pos);
                ruleSet.add(pos);
            }
            this.rules.add(new Rule(first, ruleSet));
        }
    }

    private void removeFromOtherRules(String pos) {
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule rule = (Rule)this.rules.get(i);
            if (!rule.contains(pos)) continue;
            rule.remove(pos);
            return;
        }
    }

    public List getRules() {
        return this.rules;
    }

    public Token[] process(Token[] tokens, Map postProcessInfo) {
        if (tokens.length == 0) {
            return tokens;
        }
        ArrayList<Token> newTokens = new ArrayList<Token>();
        Token prevToken = null;
        Rule currentRule = null;
        block0: for (int i = 0; i < tokens.length; ++i) {
            if (currentRule != null) {
                if (prevToken.end() != tokens[i].start() || !currentRule.contains(tokens[i].getPos())) {
                    currentRule = null;
                    newTokens.add(prevToken);
                    prevToken = null;
                } else {
                    this.merge(prevToken, tokens[i], currentRule.getPos());
                    if (i != tokens.length - 1) continue;
                    newTokens.add(prevToken);
                    continue;
                }
            }
            for (int j = 0; j < this.rules.size(); ++j) {
                Rule rule = (Rule)this.rules.get(j);
                if (!rule.contains(tokens[i].getPos())) continue;
                currentRule = rule;
                prevToken = tokens[i];
                continue block0;
            }
            currentRule = null;
            newTokens.add(tokens[i]);
        }
        Token[] newTokenArray = new Token[newTokens.size()];
        newTokens.toArray(newTokenArray);
        return newTokenArray;
    }

    private void merge(Token prev, Token current, String newPos) {
        if (prev == null) {
            return;
        }
        prev.setBasicString(prev.getBasicString() + current.getBasicString());
        prev.setCost(prev.getCost() + current.getCost());
        prev.setPos(newPos);
        prev.setPronunciation(prev.getPronunciation() + current.getPronunciation());
        prev.setReading(prev.getReading() + current.getReading());
        prev.setLength(prev.length() + current.length());
        prev.setSurface(null);
    }

    class Rule {
        private String pos;
        private Set ruleSet;

        public Rule(String pos, Set ruleSet) {
            this.pos = pos;
            this.ruleSet = ruleSet;
        }

        public String getPos() {
            return this.pos;
        }

        public boolean contains(String pos) {
            return this.ruleSet.contains(pos);
        }

        public void remove(String pos) {
            this.ruleSet.remove(pos);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.pos);
            Iterator itr = this.ruleSet.iterator();
            while (itr.hasNext()) {
                buf.append(" ").append((String)itr.next());
            }
            return new String(buf);
        }
    }
}

