/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.processor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.java.sen.Token;
import net.java.sen.processor.PostProcessor;

public class CompoundWordPostProcessor
implements PostProcessor {
    private HashMap compoundTable;

    public CompoundWordPostProcessor(String compoundFile) {
        try {
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(compoundFile));
            this.compoundTable = (HashMap)is.readObject();
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Token[] process(Token[] tokens, Map postProcessInfo) {
        if (tokens.length == 0) {
            return tokens;
        }
        ArrayList<Token> newTokens = new ArrayList<Token>();
        for (int i = 0; i < tokens.length; ++i) {
            String compoundInfo = (String)this.compoundTable.get(tokens[i].getTermInfo());
            if (compoundInfo == null) {
                newTokens.add(tokens[i]);
                continue;
            }
            StringTokenizer st = new StringTokenizer(compoundInfo);
            int start = tokens[i].start();
            while (st.hasMoreTokens()) {
                String termInfo = st.nextToken();
                Token newToken = new Token();
                String surface = this.getField(termInfo, 0);
                newToken.setSurface(surface);
                StringBuffer pos = new StringBuffer(this.getField(termInfo, 2));
                String tmp = this.getField(termInfo, 3);
                if (!tmp.equals("*")) {
                    pos.append("-").append(tmp);
                }
                if (!(tmp = this.getField(termInfo, 4)).equals("*")) {
                    pos.append("-").append(tmp);
                }
                if (!(tmp = this.getField(termInfo, 5)).equals("*")) {
                    pos.append("-").append(tmp);
                }
                newToken.setPos(new String(pos));
                newToken.setBasicString(this.getField(termInfo, 8));
                newToken.setReading(this.getField(termInfo, 9));
                newToken.setPronunciation(this.getField(termInfo, 10));
                newToken.setCost(tokens[i].getCost());
                if (this.getField(termInfo, 11).equals("-")) {
                    newToken.setAddInfo("p=" + tokens[i].getPos());
                } else {
                    newToken.setAddInfo(this.getField(termInfo, 11));
                }
                newToken.setLength(surface.length());
                newToken.setStart(start);
                start += surface.length();
                newTokens.add(newToken);
            }
        }
        Token[] newTokenArray = new Token[newTokens.size()];
        newTokens.toArray(newTokenArray);
        return newTokenArray;
    }

    private int getFieldBegin(String termInfo, int pos) {
        if (pos == 0) {
            return 0;
        }
        int cnt = 0;
        int ptr = 0;
        while (cnt < pos && ptr < termInfo.length()) {
            if (termInfo.charAt(ptr++) != ',') continue;
            ++cnt;
        }
        if (cnt != pos) {
            return -1;
        }
        return ptr++;
    }

    private String getField(String termInfo, int pos) {
        int st = this.getFieldBegin(termInfo, pos);
        int ed = this.getFieldBegin(termInfo, pos + 1);
        ed = ed == -1 || ed == termInfo.length() ? termInfo.length() : --ed;
        return termInfo.substring(st, ed);
    }
}

