/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.sen.views;

import java.io.IOException;
import jp.sourceforge.akjrcp.sen.SenTools;
import jp.sourceforge.akjrcp.sen.StringTaggerControler;
import jp.sourceforge.akjrcp.sen.views.SenView;
import net.java.sen.StringTagger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SenAction
implements IViewActionDelegate {
    private IViewPart view;
    private static final String baseActionName = "sen.actions";
    public static final String KANA = "kana";
    public static final String HATUON = "hatuon";
    public static final String GANA = "gana";
    public static final String WAKATI = "wakati";
    public static final String ID_KANA = "sen.actions.kana";
    public static final String ID_HATUON = "sen.actions.hatuon";
    public static final String ID_GANA = "sen.actions.gana";
    public static final String ID_GANA_HATUON = "sen.actions.gana_hatuon";
    public static final String ID_WAKATI = "sen.actions.wakati";
    private IWorkbenchWindow window;

    public void run(IAction action) {
        SenView senView = (SenView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(SenView.ID_VIEW);
        if (senView == null) {
            SenView.log.info((Object)"senView is null:");
        }
        try {
            String result = "";
            StringTagger taggar = SenTools.loadStringTagger();
            SenView.log.info((Object)taggar);
            StringTaggerControler controler = new StringTaggerControler(taggar);
            SenView.log.info((Object)controler);
            String input = senView.getInputArea().getText();
            SenView.log.info((Object)("inputText=" + input));
            if (action.getId().equals(ID_HATUON)) {
                result = controler.getPronunciation(input);
            } else if (action.getId().equals(ID_KANA)) {
                result = new StringTaggerControler(SenTools.loadStringTagger()).getReading(senView.getInputArea().getText());
            } else if (action.getId().equals(ID_WAKATI)) {
                result = new StringTaggerControler(SenTools.loadStringTagger()).getWakati(senView.getInputArea().getText());
            } else if (action.getId().equals(ID_GANA_HATUON)) {
                result = controler.getPronunciation(input);
                result = SenAction.kanaToGana(result);
            } else if (action.getId().equals(ID_GANA)) {
                result = new StringTaggerControler(SenTools.loadStringTagger()).getReading(senView.getInputArea().getText());
                result = SenAction.kanaToGana(result);
            }
            SenView.log.info((Object)("sen analyzed result:" + result));
            senView.getResultArea().setText(result);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
        this.view = view;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public static String kanaToGana(String s) {
        System.out.println(12449);
        System.out.println(12531);
        System.out.println(12353);
        StringBuffer sb = new StringBuffer(s);
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (c >= '\u30a1' && c <= '\u30f3') {
                sb.setCharAt(i, (char)(c - 12449 + 12353));
            }
            ++i;
        }
        return sb.toString();
    }
}

