/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tritonus.sampled.convert.PCM2PCMConversionProvider;
import org.tritonus.sampled.convert.SampleRateConversionProvider;

public class AudioUtils {
    public static Log log = LogFactory.getLog(AudioUtils.class);

    public static void mixFile(File output, File[] inputs, AudioFileFormat.Type type, AudioFormat audioFormat) throws UnsupportedAudioFileException, IOException {
        File tmpOut = File.createTempFile("newTmp", ".wav");
        log.trace((Object)("createTmp:" + tmpOut));
        log.trace((Object)("input base:" + inputs[0]));
        log.trace((Object)("format:" + audioFormat));
        FileOutputStream fout = new FileOutputStream(tmpOut);
        int readBytes = 0;
        byte[] bytedata = new byte[10280];
        long readedByte = 0L;
        int i = 0;
        while (i < inputs.length) {
            if (inputs[i].exists()) {
                readBytes = 0;
                readedByte = 0L;
                log.trace((Object)("read:" + inputs[i]));
                if (inputs[i].length() > 0L) {
                    AudioInputStream tmpInput = AudioSystem.getAudioInputStream(inputs[i]);
                    AudioInputStream readInput = AudioUtils.convert(audioFormat, tmpInput);
                    while (readBytes != -1) {
                        readBytes = readInput.read(bytedata, 0, bytedata.length);
                        if (readBytes >= 0) {
                            fout.write(bytedata, 0, readBytes);
                        }
                        readedByte += (long)readBytes;
                    }
                    log.trace((Object)("written:" + readedByte + " " + inputs[i]));
                    readInput.close();
                } else {
                    log.debug((Object)("input length: 0" + inputs[i]));
                }
            } else {
                log.debug((Object)("input not found:" + inputs[i]));
            }
            ++i;
        }
        fout.close();
        log.trace((Object)("output.length:" + tmpOut.length() + ",framesize:" + audioFormat.getChannels() * audioFormat.getFrameSize()));
        AudioInputStream finalInput = new AudioInputStream(new FileInputStream(tmpOut), audioFormat, tmpOut.length() / (long)audioFormat.getFrameSize());
        long bytes = AudioSystem.write(finalInput, type, output);
        log.trace((Object)("final write:" + output.getAbsolutePath()));
        log.trace((Object)("final write bytes:" + bytes));
        finalInput.close();
        boolean ret = tmpOut.delete();
        log.trace((Object)("tmp delete:" + ret));
    }

    public static AudioInputStream convert(AudioFormat targetFormat, AudioInputStream input) {
        return AudioUtils.convert(input, targetFormat.getSampleRate(), targetFormat.getSampleSizeInBits(), targetFormat.getChannels(), targetFormat.isBigEndian());
    }

    public static AudioInputStream convert(AudioInputStream input, float sampleRate, int samplebit, int channel, boolean bigEndian) {
        AudioFormat targetFormat;
        AudioFormat sourceFormat;
        SampleRateConversionProvider provider = new SampleRateConversionProvider();
        PCM2PCMConversionProvider pcmConverter = new PCM2PCMConversionProvider();
        AudioFormat format = input.getFormat();
        AudioInputStream result = input;
        if (format.getChannels() != channel) {
            sourceFormat = result.getFormat();
            targetFormat = new AudioFormat(sourceFormat.getEncoding(), sourceFormat.getSampleRate(), sourceFormat.getSampleSizeInBits(), channel, AudioUtils.calculateFrameSize(channel, sourceFormat.getSampleSizeInBits()), sourceFormat.getFrameRate(), sourceFormat.isBigEndian());
            result = pcmConverter.getAudioInputStream(targetFormat, result);
        }
        if (format.getSampleRate() != sampleRate) {
            sourceFormat = result.getFormat();
            targetFormat = new AudioFormat(sourceFormat.getEncoding(), sampleRate, sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), sourceFormat.getFrameSize(), sampleRate, sourceFormat.isBigEndian());
            result = provider.getAudioInputStream(targetFormat, result);
        }
        if (format.isBigEndian() != bigEndian || samplebit != format.getSampleSizeInBits()) {
            sourceFormat = result.getFormat();
            targetFormat = new AudioFormat(sourceFormat.getEncoding(), sourceFormat.getSampleRate(), samplebit, sourceFormat.getChannels(), AudioUtils.calculateFrameSize(sourceFormat.getChannels(), samplebit), sourceFormat.getFrameRate(), bigEndian);
            result = pcmConverter.getAudioInputStream(targetFormat, result);
        }
        return result;
    }

    private static int calculateFrameSize(int nChannels, int nSampleSizeInBits) {
        return (nSampleSizeInBits + 7) / 8 * nChannels;
    }
}

