/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech.mbrola;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MbrolaJP {
    public static final String VOWEL_A = "a";
    public static final String VOWEL_I = "i";
    public static final String VOWEL_U = "u";
    public static final String VOWEL_E = "e";
    public static final String VOWEL_O = "o";
    public static Log log = LogFactory.getLog(MbrolaJP.class);
    private String voicePath;
    private String mbrolaPath;
    private String smallPattern = " 22   4 30    10 30    20 35";
    private String smallVowelPattern = "  45   14 152    47 150    42 156";
    private String normalPattern = " 85   14 152    47 153    82 156";
    private List wordList;
    private Process process;

    public MbrolaJP() {
        this.init();
    }

    public String getMbrolaPath() {
        return this.mbrolaPath;
    }

    public void setMbrolaPath(String mbrolaPath) {
        log.info((Object)("mbrola.exe or mbrola setted:" + mbrolaPath));
        this.mbrolaPath = mbrolaPath;
    }

    public String getVoicePath() {
        return this.voicePath;
    }

    public void setVoicePath(String voicePath) {
        log.info((Object)("mbrola voice path setted:" + voicePath));
        this.voicePath = voicePath;
    }

    public void speak(File file, String text) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        File tmp = File.createTempFile("voice", ".txt");
        this.writeVoiceTextFile(tmp, text);
        if (this.mbrolaPath == null || !new File(this.mbrolaPath).exists()) {
            throw new IOException("mbrola not found");
        }
        if (this.voicePath == null || !new File(this.voicePath).exists()) {
            throw new IOException("mbrola voice not found");
        }
        try {
            String[] arg = new String[]{this.mbrolaPath, this.voicePath, tmp.getAbsolutePath(), file.getAbsolutePath()};
            if (log.isTraceEnabled()) {
                String tmptxt = "";
                int i = 0;
                while (i < arg.length) {
                    tmptxt = String.valueOf(tmptxt) + "\"" + arg[i] + "\"" + " ";
                    ++i;
                }
                log.trace((Object)tmptxt);
            }
            this.process = runtime.exec(arg);
            this.process.waitFor();
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private void writeVoiceTextFile(File file, String text2) throws IOException {
        String[] all = this.convert(text2);
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < all.length) {
            if (all[i].equals("f") && i != 0 && (all[i - 1].equals(VOWEL_U) || all[i - 1].equals("\u3045"))) {
                text.append("_" + this.smallPattern + "\n");
            }
            if (all[i].equals("N") && (i == 0 || all[i - 1].equals("_") || all[i - 1].equals("N"))) {
                text.append(VOWEL_U + this.normalPattern + "\n");
            }
            if (all[i].equals("\u3063")) {
                text.append("ts" + this.smallPattern + "\n");
                text.append(VOWEL_U + this.smallPattern + "\n");
            } else if (all[i].equals("\u3041")) {
                text.append(VOWEL_A + this.smallVowelPattern + "\n");
            } else if (all[i].equals("\u3043")) {
                text.append(VOWEL_I + this.smallVowelPattern + "\n");
            } else if (all[i].equals("\u3045")) {
                text.append(VOWEL_U + this.smallVowelPattern + "\n");
            } else if (all[i].equals("\u3047")) {
                text.append(VOWEL_E + this.smallVowelPattern + "\n");
            } else if (all[i].equals("\u3049")) {
                text.append(VOWEL_O + this.smallVowelPattern + "\n");
            } else {
                text.append(String.valueOf(all[i]) + this.normalPattern + "\n");
            }
            ++i;
        }
        log.trace((Object)text);
        log.debug((Object)("write:" + file.getAbsolutePath()));
        FileWriter writer = new FileWriter(file);
        writer.write(text.toString());
        writer.close();
    }

    private String[] convert(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] words = this.getWords();
        Arrays.sort(words);
        new HashMap();
        Object pre = null;
        while (string.length() > 0) {
            boolean match = false;
            int i = 0;
            while (i < words.length) {
                if (string.startsWith(((Word)words[i]).getKana())) {
                    match = true;
                    String[] keys = ((Word)words[i]).getMbrola();
                    if (((Word)words[i]).getKana().equals("\u30fc")) {
                        if (pre != null) {
                            String lastvowel = ((Word)pre).getMbrola()[((Word)pre).getMbrola().length - 1];
                            arrayList.add(((Word)pre).getMbrola()[((Word)pre).getMbrola().length - 1]);
                            ((Word)words[i]).setMbrola(new String[]{lastvowel});
                        }
                    } else {
                        int j = 0;
                        while (j < keys.length) {
                            arrayList.add(keys[j]);
                            ++j;
                        }
                    }
                    pre = words[i];
                    string = string.substring(((Word)words[i]).getKana().length());
                    log.trace((Object)("match:" + words[i]));
                    break;
                }
                ++i;
            }
            if (string.length() <= 0 || match) continue;
            System.out.println("not match:" + string.charAt(0));
            string = string.substring(1);
        }
        return arrayList.toArray(new String[0]);
    }

    public Word[] getWords() {
        return this.wordList.toArray(new Word[this.wordList.size()]);
    }

    public void init() {
        this.wordList = new ArrayList();
        this.wordList.add(new Word("\u3042", new String[]{VOWEL_A}));
        this.wordList.add(new Word("\u3044", new String[]{VOWEL_I}));
        this.wordList.add(new Word("\u3046", new String[]{VOWEL_U}));
        this.wordList.add(new Word("\u3048", new String[]{VOWEL_E}));
        this.wordList.add(new Word("\u304a", new String[]{VOWEL_O}));
        this.wordList.add(new Word("\u304b", new String[]{"k", VOWEL_A}));
        this.wordList.add(new Word("\u304c", new String[]{"g", VOWEL_A}));
        this.wordList.add(new Word("\u304d", new String[]{"k", VOWEL_I}));
        this.wordList.add(new Word("\u304e", new String[]{"g", VOWEL_I}));
        this.wordList.add(new Word("\u304f", new String[]{"k", VOWEL_U}));
        this.wordList.add(new Word("\u3050", new String[]{"g", VOWEL_U}));
        this.wordList.add(new Word("\u3051", new String[]{"k", VOWEL_E}));
        this.wordList.add(new Word("\u3052", new String[]{"g", VOWEL_E}));
        this.wordList.add(new Word("\u3053", new String[]{"k", VOWEL_O}));
        this.wordList.add(new Word("\u3054", new String[]{"g", VOWEL_O}));
        this.wordList.add(new Word("\u3055", new String[]{"s", VOWEL_A}));
        this.wordList.add(new Word("\u3056", new String[]{"z", VOWEL_A}));
        this.wordList.add(new Word("\u3057", new String[]{"s", VOWEL_I}));
        this.wordList.add(new Word("\u3058", new String[]{"z", VOWEL_I}));
        this.wordList.add(new Word("\u3059", new String[]{"s", VOWEL_U}));
        this.wordList.add(new Word("\u305a", new String[]{"z", VOWEL_U}));
        this.wordList.add(new Word("\u305b", new String[]{"s", VOWEL_E}));
        this.wordList.add(new Word("\u305c", new String[]{"z", VOWEL_E}));
        this.wordList.add(new Word("\u305d", new String[]{"s", VOWEL_O}));
        this.wordList.add(new Word("\u305e", new String[]{"z", VOWEL_O}));
        this.wordList.add(new Word("\u305f", new String[]{"t", VOWEL_A}));
        this.wordList.add(new Word("\u3060", new String[]{"d", VOWEL_A}));
        this.wordList.add(new Word("\u3061", new String[]{"tS", VOWEL_I}));
        this.wordList.add(new Word("\u3062", new String[]{"dZ", VOWEL_I}));
        this.wordList.add(new Word("\u3064", new String[]{"ts", VOWEL_U}));
        this.wordList.add(new Word("\u3065", new String[]{"dZ", VOWEL_A}));
        this.wordList.add(new Word("\u3066", new String[]{"t", VOWEL_E}));
        this.wordList.add(new Word("\u3067", new String[]{"d", VOWEL_E}));
        this.wordList.add(new Word("\u3068", new String[]{"t", VOWEL_O}));
        this.wordList.add(new Word("\u3069", new String[]{"d", VOWEL_O}));
        this.wordList.add(new Word("\u306a", new String[]{"n", VOWEL_A}));
        this.wordList.add(new Word("\u306b", new String[]{"n", VOWEL_I}));
        this.wordList.add(new Word("\u306c", new String[]{"n", VOWEL_U}));
        this.wordList.add(new Word("\u306d", new String[]{"n", VOWEL_E}));
        this.wordList.add(new Word("\u306e", new String[]{"n", VOWEL_O}));
        this.wordList.add(new Word("\u306f", new String[]{"h", VOWEL_A}));
        this.wordList.add(new Word("\u3070", new String[]{"b", VOWEL_A}));
        this.wordList.add(new Word("\u3071", new String[]{"p", VOWEL_A}));
        this.wordList.add(new Word("\u3072", new String[]{"h", VOWEL_I}));
        this.wordList.add(new Word("\u3073", new String[]{"b", VOWEL_I}));
        this.wordList.add(new Word("\u3074", new String[]{"p", VOWEL_I}));
        this.wordList.add(new Word("\u3075", new String[]{"h", VOWEL_U}));
        this.wordList.add(new Word("\u3076", new String[]{"b", VOWEL_U}));
        this.wordList.add(new Word("\u3077", new String[]{"p", VOWEL_U}));
        this.wordList.add(new Word("\u3078", new String[]{"h", VOWEL_E}));
        this.wordList.add(new Word("\u3079", new String[]{"b", VOWEL_E}));
        this.wordList.add(new Word("\u307a", new String[]{"p", VOWEL_E}));
        this.wordList.add(new Word("\u307b", new String[]{"h", VOWEL_O}));
        this.wordList.add(new Word("\u307c", new String[]{"b", VOWEL_O}));
        this.wordList.add(new Word("\u307d", new String[]{"p", VOWEL_O}));
        this.wordList.add(new Word("\u307e", new String[]{"m", VOWEL_A}));
        this.wordList.add(new Word("\u307f", new String[]{"m", VOWEL_I}));
        this.wordList.add(new Word("\u3080", new String[]{"m", VOWEL_U}));
        this.wordList.add(new Word("\u3081", new String[]{"m", VOWEL_E}));
        this.wordList.add(new Word("\u3082", new String[]{"m", VOWEL_O}));
        this.wordList.add(new Word("\u3084", new String[]{"j", VOWEL_A}));
        this.wordList.add(new Word("\u3086", new String[]{"j", VOWEL_U}));
        this.wordList.add(new Word("\u3088", new String[]{"j", VOWEL_O}));
        this.wordList.add(new Word("\u3089", new String[]{"rr", VOWEL_A}));
        this.wordList.add(new Word("\u308a", new String[]{"rr", VOWEL_I}));
        this.wordList.add(new Word("\u308b", new String[]{"rr", VOWEL_U}));
        this.wordList.add(new Word("\u308c", new String[]{"rr", VOWEL_E}));
        this.wordList.add(new Word("\u308d", new String[]{"rr", VOWEL_O}));
        this.wordList.add(new Word("\u308f", new String[]{"w", VOWEL_A}));
        this.wordList.add(new Word("\u308e", new String[]{"w", VOWEL_A}));
        this.wordList.add(new Word("\u3092", new String[]{VOWEL_U, VOWEL_O}));
        this.wordList.add(new Word("\u3093", new String[]{"N"}));
        this.wordList.add(new Word("\u3075\u3041", new String[]{"f", VOWEL_A}));
        this.wordList.add(new Word("\u3075\u3043", new String[]{"f", VOWEL_I}));
        this.wordList.add(new Word("\u3075\u3047", new String[]{"f", VOWEL_E}));
        this.wordList.add(new Word("\u3075\u3049", new String[]{"f", VOWEL_O}));
        this.wordList.add(new Word("\u307f\u3083", new String[]{"m", "j", VOWEL_A}));
        this.wordList.add(new Word("\u307f\u3085", new String[]{"m", "j", VOWEL_U}));
        this.wordList.add(new Word("\u307f\u3087", new String[]{"m", "j", VOWEL_O}));
        this.wordList.add(new Word("\u304d\u3083", new String[]{"k", "j", VOWEL_A}));
        this.wordList.add(new Word("\u304d\u3085", new String[]{"k", "j", VOWEL_U}));
        this.wordList.add(new Word("\u304d\u3087", new String[]{"k", "j", VOWEL_O}));
        this.wordList.add(new Word("\u304e\u3083", new String[]{"g", "j", VOWEL_A}));
        this.wordList.add(new Word("\u304e\u3085", new String[]{"g", "j", VOWEL_U}));
        this.wordList.add(new Word("\u304e\u3087", new String[]{"g", "j", VOWEL_O}));
        this.wordList.add(new Word("\u3057\u3083", new String[]{"S", VOWEL_A}));
        this.wordList.add(new Word("\u3057\u3085", new String[]{"S", VOWEL_U}));
        this.wordList.add(new Word("\u3057\u3087", new String[]{"S", VOWEL_O}));
        this.wordList.add(new Word("\u3061\u3083", new String[]{"tS", VOWEL_A}));
        this.wordList.add(new Word("\u3061\u3085", new String[]{"tS", VOWEL_U}));
        this.wordList.add(new Word("\u3061\u3087", new String[]{"tS", VOWEL_O}));
        this.wordList.add(new Word("\u3058\u3083", new String[]{"d", "j", VOWEL_A}));
        this.wordList.add(new Word("\u3058\u3085", new String[]{"d", "j", VOWEL_U}));
        this.wordList.add(new Word("\u3058\u3087", new String[]{"d", "j", VOWEL_O}));
        this.wordList.add(new Word("\u3072\u3083", new String[]{"h", "j", VOWEL_A}));
        this.wordList.add(new Word("\u3072\u3085", new String[]{"h", "j", VOWEL_U}));
        this.wordList.add(new Word("\u3072\u3087", new String[]{"h", "j", VOWEL_O}));
        this.wordList.add(new Word("\u3073\u3083", new String[]{"b", "j", VOWEL_A}));
        this.wordList.add(new Word("\u3073\u3085", new String[]{"b", "j", VOWEL_U}));
        this.wordList.add(new Word("\u3073\u3087", new String[]{"b", "j", VOWEL_O}));
        this.wordList.add(new Word("\u3001", new String[]{"_"}));
        this.wordList.add(new Word("\u3002", new String[]{"_"}));
        this.wordList.add(new Word("\u3063", new String[]{"\u3063"}));
        this.wordList.add(new Word("\u3041", new String[]{"\u3041"}));
        this.wordList.add(new Word("\u3043", new String[]{"\u3043"}));
        this.wordList.add(new Word("\u3045", new String[]{"\u3045"}));
        this.wordList.add(new Word("\u3047", new String[]{"\u3047"}));
        this.wordList.add(new Word("\u3049", new String[]{"\u3049"}));
        this.wordList.add(new Word("\u30fc", new String[]{"_"}));
        this.wordList.add(new Word("\u30a2", new String[]{VOWEL_A}));
        this.wordList.add(new Word("\u30a4", new String[]{VOWEL_I}));
        this.wordList.add(new Word("\u30a6", new String[]{VOWEL_U}));
        this.wordList.add(new Word("\u30a8", new String[]{VOWEL_E}));
        this.wordList.add(new Word("\u30aa", new String[]{VOWEL_O}));
        this.wordList.add(new Word("\u30ab", new String[]{"k", VOWEL_A}));
        this.wordList.add(new Word("\u30ac", new String[]{"g", VOWEL_A}));
        this.wordList.add(new Word("\u30ad", new String[]{"k", VOWEL_I}));
        this.wordList.add(new Word("\u30ae", new String[]{"g", VOWEL_I}));
        this.wordList.add(new Word("\u30af", new String[]{"k", VOWEL_U}));
        this.wordList.add(new Word("\u30b0", new String[]{"g", VOWEL_U}));
        this.wordList.add(new Word("\u30b1", new String[]{"k", VOWEL_E}));
        this.wordList.add(new Word("\u30b2", new String[]{"g", VOWEL_E}));
        this.wordList.add(new Word("\u30b3", new String[]{"k", VOWEL_O}));
        this.wordList.add(new Word("\u30b4", new String[]{"g", VOWEL_O}));
        this.wordList.add(new Word("\u30b5", new String[]{"s", VOWEL_A}));
        this.wordList.add(new Word("\u30b6", new String[]{"z", VOWEL_A}));
        this.wordList.add(new Word("\u30b7", new String[]{"s", VOWEL_I}));
        this.wordList.add(new Word("\u30b8", new String[]{"z", VOWEL_I}));
        this.wordList.add(new Word("\u30b9", new String[]{"s", VOWEL_U}));
        this.wordList.add(new Word("\u30ba", new String[]{"z", VOWEL_U}));
        this.wordList.add(new Word("\u30bb", new String[]{"s", VOWEL_E}));
        this.wordList.add(new Word("\u30bc", new String[]{"z", VOWEL_E}));
        this.wordList.add(new Word("\u30bd", new String[]{"s", VOWEL_O}));
        this.wordList.add(new Word("\u30be", new String[]{"z", VOWEL_O}));
        this.wordList.add(new Word("\u30bf", new String[]{"t", VOWEL_A}));
        this.wordList.add(new Word("\u30c0", new String[]{"d", VOWEL_A}));
        this.wordList.add(new Word("\u30c1", new String[]{"tS", VOWEL_I}));
        this.wordList.add(new Word("\u30c2", new String[]{"dZ", VOWEL_I}));
        this.wordList.add(new Word("\u30c4", new String[]{"ts", VOWEL_U}));
        this.wordList.add(new Word("\u30c5", new String[]{"dZ", VOWEL_A}));
        this.wordList.add(new Word("\u30c6", new String[]{"t", VOWEL_E}));
        this.wordList.add(new Word("\u30c7", new String[]{"d", VOWEL_E}));
        this.wordList.add(new Word("\u30c8", new String[]{"t", VOWEL_O}));
        this.wordList.add(new Word("\u30c9", new String[]{"d", VOWEL_O}));
        this.wordList.add(new Word("\u30ca", new String[]{"n", VOWEL_A}));
        this.wordList.add(new Word("\u30cb", new String[]{"n", VOWEL_I}));
        this.wordList.add(new Word("\u30cc", new String[]{"n", VOWEL_U}));
        this.wordList.add(new Word("\u30cd", new String[]{"n", VOWEL_E}));
        this.wordList.add(new Word("\u30ce", new String[]{"n", VOWEL_O}));
        this.wordList.add(new Word("\u30cf", new String[]{"h", VOWEL_A}));
        this.wordList.add(new Word("\u30d0", new String[]{"b", VOWEL_A}));
        this.wordList.add(new Word("\u30d1", new String[]{"p", VOWEL_A}));
        this.wordList.add(new Word("\u30d2", new String[]{"h", VOWEL_I}));
        this.wordList.add(new Word("\u30d3", new String[]{"b", VOWEL_I}));
        this.wordList.add(new Word("\u30d4", new String[]{"p", VOWEL_I}));
        this.wordList.add(new Word("\u30d5", new String[]{"h", VOWEL_U}));
        this.wordList.add(new Word("\u30d6", new String[]{"b", VOWEL_U}));
        this.wordList.add(new Word("\u30d7", new String[]{"p", VOWEL_U}));
        this.wordList.add(new Word("\u30d8", new String[]{"h", VOWEL_E}));
        this.wordList.add(new Word("\u30d9", new String[]{"b", VOWEL_E}));
        this.wordList.add(new Word("\u30da", new String[]{"p", VOWEL_E}));
        this.wordList.add(new Word("\u30db", new String[]{"h", VOWEL_O}));
        this.wordList.add(new Word("\u30dc", new String[]{"b", VOWEL_O}));
        this.wordList.add(new Word("\u30dd", new String[]{"p", VOWEL_O}));
        this.wordList.add(new Word("\u30de", new String[]{"m", VOWEL_A}));
        this.wordList.add(new Word("\u30df", new String[]{"m", VOWEL_I}));
        this.wordList.add(new Word("\u30e0", new String[]{"m", VOWEL_U}));
        this.wordList.add(new Word("\u30e1", new String[]{"m", VOWEL_E}));
        this.wordList.add(new Word("\u30e2", new String[]{"m", VOWEL_O}));
        this.wordList.add(new Word("\u30e4", new String[]{"j", VOWEL_A}));
        this.wordList.add(new Word("\u30e6", new String[]{"j", VOWEL_U}));
        this.wordList.add(new Word("\u30e8", new String[]{"j", VOWEL_O}));
        this.wordList.add(new Word("\u30e9", new String[]{"rr", VOWEL_A}));
        this.wordList.add(new Word("\u30ea", new String[]{"rr", VOWEL_I}));
        this.wordList.add(new Word("\u30eb", new String[]{"rr", VOWEL_U}));
        this.wordList.add(new Word("\u30ec", new String[]{"rr", VOWEL_E}));
        this.wordList.add(new Word("\u30ed", new String[]{"rr", VOWEL_O}));
        this.wordList.add(new Word("\u30ef", new String[]{"w", VOWEL_A}));
        this.wordList.add(new Word("\u30ee", new String[]{"w", VOWEL_A}));
        this.wordList.add(new Word("\u30f2", new String[]{VOWEL_U, VOWEL_O}));
        this.wordList.add(new Word("\u30f3", new String[]{"N"}));
        this.wordList.add(new Word("\u30d5\u30a1", new String[]{"f", VOWEL_A}));
        this.wordList.add(new Word("\u30d5\u30a3", new String[]{"f", VOWEL_I}));
        this.wordList.add(new Word("\u30d5\u30a7", new String[]{"f", VOWEL_E}));
        this.wordList.add(new Word("\u30d5\u30a9", new String[]{"f", VOWEL_O}));
        this.wordList.add(new Word("\u30df\u30e3", new String[]{"m", "j", VOWEL_A}));
        this.wordList.add(new Word("\u30df\u30e5", new String[]{"m", "j", VOWEL_U}));
        this.wordList.add(new Word("\u30df\u30e7", new String[]{"m", "j", VOWEL_O}));
        this.wordList.add(new Word("\u30ad\u30e3", new String[]{"k", "j", VOWEL_A}));
        this.wordList.add(new Word("\u30ad\u30e5", new String[]{"k", "j", VOWEL_U}));
        this.wordList.add(new Word("\u30ad\u30e7", new String[]{"k", "j", VOWEL_O}));
        this.wordList.add(new Word("\u30ae\u30e3", new String[]{"g", "j", VOWEL_A}));
        this.wordList.add(new Word("\u30ae\u30e5", new String[]{"g", "j", VOWEL_U}));
        this.wordList.add(new Word("\u30ae\u30e7", new String[]{"g", "j", VOWEL_O}));
        this.wordList.add(new Word("\u30b7\u30e3", new String[]{"S", VOWEL_A}));
        this.wordList.add(new Word("\u30b7\u30e5", new String[]{"S", VOWEL_U}));
        this.wordList.add(new Word("\u30b7\u30e7", new String[]{"S", VOWEL_O}));
        this.wordList.add(new Word("\u30c1\u30e3", new String[]{"tS", VOWEL_A}));
        this.wordList.add(new Word("\u30c1\u30e5", new String[]{"tS", VOWEL_U}));
        this.wordList.add(new Word("\u30c1\u30e7", new String[]{"tS", VOWEL_O}));
        this.wordList.add(new Word("\u30b8\u30e3", new String[]{"d", "j", VOWEL_A}));
        this.wordList.add(new Word("\u30b8\u30e5", new String[]{"d", "j", VOWEL_U}));
        this.wordList.add(new Word("\u30b8\u30e7", new String[]{"d", "j", VOWEL_O}));
        this.wordList.add(new Word("\u30d2\u30e3", new String[]{"h", "j", VOWEL_A}));
        this.wordList.add(new Word("\u30d2\u30e5", new String[]{"h", "j", VOWEL_U}));
        this.wordList.add(new Word("\u30d2\u30e7", new String[]{"h", "j", VOWEL_O}));
        this.wordList.add(new Word("\u30d3\u30e3", new String[]{"b", "j", VOWEL_A}));
        this.wordList.add(new Word("\u30d3\u30e5", new String[]{"b", "j", VOWEL_U}));
        this.wordList.add(new Word("\u30d3\u30e7", new String[]{"b", "j", VOWEL_O}));
        this.wordList.add(new Word("\u30c3", new String[]{"\u3063"}));
        this.wordList.add(new Word("\u30a1", new String[]{"\u3041"}));
        this.wordList.add(new Word("\u30a3", new String[]{"\u3043"}));
        this.wordList.add(new Word("\u30a5", new String[]{"\u3045"}));
        this.wordList.add(new Word("\u30a7", new String[]{"\u3047"}));
        this.wordList.add(new Word("\u30a9", new String[]{"\u3049"}));
        this.wordList.add(new Word("\u30f4", new String[]{"v", VOWEL_A}));
        this.wordList.add(new Word("\u30f4\u3041\u3075\u3041", new String[]{"v", VOWEL_A, "f", VOWEL_A}));
    }

    public static String toKana(String gana) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < gana.length()) {
            if (gana.charAt(i) >= '\u3041' && gana.charAt(i) <= '\u3093') {
                result.append((char)(gana.charAt(i) + 96));
            } else {
                result.append(gana.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public static String toGana(String kana) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < kana.length()) {
            if (kana.charAt(i) >= '\u3041' && kana.charAt(i) <= '\u3093') {
                result.append((char)(kana.charAt(i) - 96));
            } else {
                result.append(kana.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public class Word
    implements Comparable {
        private String kana;
        private String[] mbrola;

        public Word(String kana, String[] mbrola) {
            this.kana = kana;
            this.mbrola = mbrola;
        }

        public String getKana() {
            return this.kana;
        }

        public void setKana(String kana) {
            this.kana = kana;
        }

        public String[] getMbrola() {
            return this.mbrola;
        }

        public void setMbrola(String[] mbrola) {
            this.mbrola = mbrola;
        }

        public int compareTo(Object o) {
            if (o instanceof Word) {
                Word other = (Word)o;
                return other.getKana().compareTo(this.kana);
            }
            return 0;
        }

        public String toString() {
            String v = "";
            int i = 0;
            while (i < this.mbrola.length) {
                v = String.valueOf(v) + this.mbrola[i] + " ";
                ++i;
            }
            v = v.substring(0, v.length() - 1);
            return String.valueOf(this.kana) + "," + v;
        }
    }
}

