/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech.mbrola;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.commons.plugin.PluginUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;

public class MbrolaUtils {
    public static Log log = LogFactory.getLog(MbrolaUtils.class);

    public static File getMboraExecuteFile() {
        File mboraDir = MbrolaUtils.getMboraDirectory();
        if (mboraDir != null && Platform.getOS().equals("win32")) {
            File file = new File(mboraDir, "mbrola.exe");
            if (file.exists() && file.isFile()) {
                log.info((Object)("find-mbrola.exe:" + file.getAbsolutePath()));
                return file;
            }
            file = new File(mboraDir, "mbrola");
            if (file.exists() && file.isFile()) {
                log.info((Object)("find-mbrola.exe:" + file.getAbsolutePath()));
                return file;
            }
        }
        log.warn((Object)"mbrola dir not found");
        return null;
    }

    public static File getMboraDirectory() {
        File file;
        File tmp;
        File mbrolaDir = null;
        if (System.getProperty("mbrola.home") != null && (tmp = new File(System.getProperty("mbrola.home"))).exists() && tmp.isDirectory()) {
            mbrolaDir = tmp;
        }
        if (Platform.getOS().equals("win32")) {
            file = new File("C:\\Program Files\\mbrola");
            if (file.exists() && file.isDirectory()) {
                mbrolaDir = file;
            }
        } else {
            file = new File("/usr/local/bin/mbrola");
            if (file.exists() && file.isDirectory()) {
                mbrolaDir = file;
            }
        }
        if (mbrolaDir != null) {
            log.info((Object)("find mbrola:" + mbrolaDir.getAbsolutePath()));
            return mbrolaDir;
        }
        tmp = PluginUtils.getPluginDir((String)"jp.sourceforge.akjrcp.lib.mbrola");
        if (tmp == null) {
            log.warn((Object)"mbrola-plug in nout found:jp.sourceforge.akjrcp.lib.mbrola");
            return null;
        }
        File underPluginMbrola = new File(tmp, "mbrola");
        if (underPluginMbrola.exists() && underPluginMbrola.isDirectory()) {
            log.info((Object)("find mbrola in mbrola-plugin:" + underPluginMbrola.getAbsolutePath()));
            return underPluginMbrola;
        }
        log.warn((Object)("mbrola-plugin found but no mbrola:" + underPluginMbrola.getAbsolutePath()));
        return null;
    }

    public static String[] getMboraUSDataNames() {
        File dir = MbrolaUtils.getMboraDirectory();
        ArrayList<String> dirNameList = new ArrayList<String>();
        if (dir != null && dir.exists()) {
            int i = 1;
            while (i <= 3) {
                File tmp = new File(dir, "us" + i);
                if (tmp.isDirectory()) {
                    dirNameList.add("us" + i);
                }
                ++i;
            }
            return dirNameList.toArray(new String[dirNameList.size()]);
        }
        return new String[0];
    }
}

