/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech.views;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.commons.ui.dialog.FileOverwriteControler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.jpn.xucker.rcp.speech.AudioFileUtils;
import org.jpn.xucker.rcp.speech.Messages;
import org.jpn.xucker.rcp.speech.SpeechPlugin;
import org.jpn.xucker.rcp.speech.views.PlayTextView;
import org.jpn.xucker.rcp.speech.wizards.MultiOutput;

public class ExportAudioView
extends ViewPart {
    public static final String VIEW_ID = ExportAudioView.class.getName();
    public static Log log = LogFactory.getLog(ExportAudioView.class);

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Button button = new Button(parent, 0);
        button.setText(Messages.getString("save_file"));
        button.addSelectionListener((SelectionListener)new ExportFile());
        Button button2 = new Button(parent, 0);
        button2.setText(Messages.getString("save_multi"));
        button2.addSelectionListener((SelectionListener)new ExportMulti());
    }

    public void setFocus() {
    }

    public static class ExportFile
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            String text = ((PlayTextView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(PlayTextView.VIEW_ID)).getText();
            if (text.length() == 0) {
                return;
            }
            FileDialog chooser = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
            String defaultPath = SpeechPlugin.getDefault().getPreferenceStore().getString("export.directory");
            if (defaultPath.length() > 0) {
                chooser.setFilterPath(defaultPath);
            }
            chooser.setFilterExtensions(AudioFileUtils.createFileDialogExtension());
            chooser.setFilterNames(AudioFileUtils.createFileDialogName());
            String path = chooser.open();
            if (path != null) {
                File file = new File(path);
                FileOverwriteControler controler = new FileOverwriteControler(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                if (!controler.canOverwrite(file)) {
                    return;
                }
                String name = file.getAbsolutePath();
                log.trace((Object)("playing:" + SpeechPlugin.getDefault().getSpeech().isPlaying()));
                if (!SpeechPlugin.getDefault().getSpeech().isPlaying()) {
                    try {
                        SpeechPlugin.getDefault().getSpeech().write(new File(name), text);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public static class ExportMulti
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            MultiOutput output = new MultiOutput();
            output.init(PlatformUI.getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)output);
            try {
                dialog.open();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

