/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech.wizards;

import java.io.IOException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.jpn.xucker.rcp.speech.Messages;
import org.jpn.xucker.rcp.speech.views.PlayTextView;
import org.jpn.xucker.rcp.speech.wizards.FileNameChoose;
import org.jpn.xucker.rcp.speech.wizards.FileNameUtils;
import org.jpn.xucker.rcp.speech.wizards.MultiOutput;

public class MultiOutputWizardFileNamePage
extends WizardPage {
    private ISelection selection;
    private FileNameChoose chooser;

    public MultiOutputWizardFileNamePage(ISelection selection) {
        super(Messages.getString("splitexport"));
        this.setTitle(Messages.getString("choose_how_to_renamefile"));
        this.setDescription(Messages.getString("define_filename"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.chooser = new FileNameChoose(composite, 0);
        this.initialize();
    }

    private void initialize() {
        PlayTextView cfr_ignored_0 = (PlayTextView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(PlayTextView.VIEW_ID);
        this.chooser.updateTable();
    }

    public String[] getFileNames(String[] texts) {
        if (this.chooser != null) {
            return this.getFileNames(texts, this.chooser.getFileNameHeader(), this.chooser.getFileNameFooter(), this.chooser.getNumberLength());
        }
        return this.getFileNames(texts, "", "", "3");
    }

    private String[] getFileNames(String[] texts, String header, String footer, String num) {
        String[] result = new String[texts.length];
        int i = 0;
        while (i < texts.length) {
            result[i] = this.chooser == null || this.chooser.isNumberName() ? String.valueOf(header) + this.toNumber(i + 1, num) + footer + MultiOutput.current.getExtension() : FileNameUtils.replaceNonFileName(String.valueOf(texts[i]) + MultiOutput.current.getExtension(), "", 128);
            ++i;
        }
        if (this.chooser != null && !this.chooser.isNumberName()) {
            try {
                result = FileNameUtils.avoidSameName(result, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private String toNumber(int number, String num) {
        int k = Integer.parseInt(num);
        String result = "" + number;
        while (result.length() < k) {
            result = "0" + result;
        }
        return result;
    }

    public void updateTable() {
        this.chooser.updateTable();
    }
}

