/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.speech;

import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.audio.SingleFileAudioPlayer;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.speech.CustomJavaAudioPlayer;

public class VoicePlayer {
    AudioPlayer player;
    public static Log log = LogFactory.getLog(VoicePlayer.class);

    public void play(Voice voice, String text) {
        log.trace((Object)("play:" + voice.getName() + ",duration=" + voice.getDurationStretch() + ",pitch=" + voice.getPitch() + ",pitchRange=" + voice.getPitchRange() + ",pitchShift=" + voice.getPitchShift() + ",text=" + text));
        this.player = new CustomJavaAudioPlayer();
        voice.setAudioPlayer(this.player);
        boolean result = voice.speak(VoicePlayer.removeWhilteSpaceEnd(text));
        this.player.close();
        log.trace((Object)("result:" + result));
    }

    public void cancel() {
        this.player.pause();
        this.player.cancel();
    }

    public void write(Voice voice, String text, File file) {
        if (text.length() == 0) {
            log.info((Object)"text empty");
            return;
        }
        String wiredPath = file.getAbsolutePath();
        if (wiredPath.endsWith(".wav")) {
            wiredPath = wiredPath.substring(0, wiredPath.length() - 4);
        }
        this.player = new SingleFileAudioPlayer(wiredPath, AudioFileFormat.Type.WAVE);
        voice.setAudioPlayer(this.player);
        String speakText = VoicePlayer.removeWhilteSpaceEnd(text);
        log.trace((Object)("'" + speakText + "'"));
        if (speakText.length() == 0) {
            log.info((Object)"speakText empty");
            return;
        }
        voice.speak(speakText);
        this.player.close();
        if (!file.getAbsolutePath().endsWith(".wav")) {
            new File(String.valueOf(wiredPath) + ".wav").renameTo(file);
        }
    }

    public static String removeWhilteSpaceEnd(String text) {
        while (text.length() > 0) {
            if (!Character.isWhitespace(text.charAt(text.length() - 1))) break;
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

