/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.speech.multi;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.speech.multi.GtalkPlayer;
import org.jpn.xucker.speech.multi.MbrolaJPPlayer;
import org.jpn.xucker.speech.multi.MultiTypeText;
import org.jpn.xucker.speech.multi.MultiTypeTextPlayer;

public class GtalkMbrolaJPPlayer
implements MultiTypeTextPlayer {
    public static Log log = LogFactory.getLog(GtalkMbrolaJPPlayer.class);
    private boolean enabled = true;
    private GtalkPlayer gtalkPlayer;
    private MbrolaJPPlayer mbrolaJPPlayer;
    public static final String MBROLA_JP3 = "mbrola_jp3";
    public static final String GTALK_MALE1 = "male01";
    public static final String GTALK_MALE2 = "male02";
    public static final String GTALK_FEMELE1 = "female01";
    private String voice = "male01";
    private boolean useIpadic;

    public boolean isUseIpadic() {
        return this.useIpadic;
    }

    public void setUseIpadic(boolean useIpadic) {
        this.useIpadic = useIpadic;
        this.gtalkPlayer.setConvertPronounce(useIpadic);
    }

    public GtalkPlayer getGtalkPlayer() {
        return this.gtalkPlayer;
    }

    public void setGtalkPlayer(GtalkPlayer gtalkPlayer) {
        this.gtalkPlayer = gtalkPlayer;
    }

    public boolean isMbrokaJP() {
        return this.voice.equals(MBROLA_JP3);
    }

    public MbrolaJPPlayer getMbrolaJPPlayer() {
        return this.mbrolaJPPlayer;
    }

    public void setMbrolaJPPlayer(MbrolaJPPlayer mbrolaJPPlayer) {
        this.mbrolaJPPlayer = mbrolaJPPlayer;
    }

    @Override
    public boolean available(MultiTypeText text) {
        if (this.isEnabled()) {
            if (this.isMbrokaJP()) {
                return this.mbrolaJPPlayer.available(text);
            }
            return this.gtalkPlayer.available(text);
        }
        return false;
    }

    @Override
    public void play(MultiTypeText text) {
        if (this.isMbrokaJP()) {
            this.mbrolaJPPlayer.play(text);
        } else {
            this.gtalkPlayer.play(text);
        }
    }

    @Override
    public void write(MultiTypeText text, File file) {
        if (this.isMbrokaJP()) {
            this.mbrolaJPPlayer.write(text, file);
        } else {
            this.gtalkPlayer.write(text, file);
        }
    }

    @Override
    public void cancel() {
        if (this.isMbrokaJP()) {
            this.mbrolaJPPlayer.cancel();
        } else {
            this.gtalkPlayer.cancel();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bool) {
        log.trace((Object)("enabled:" + bool));
        this.enabled = bool;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String voice) {
        log.trace((Object)voice);
        this.voice = voice;
        if (!voice.equals(MBROLA_JP3)) {
            this.gtalkPlayer.getGtalk().setSpeaker(voice);
        }
    }

    @Override
    public void dispose() {
        this.gtalkPlayer.dispose();
        this.mbrolaJPPlayer.dispose();
    }
}

