/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.speech.multi;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.speech.mbrola.MbrolaJP;
import org.jpn.xucker.speech.multi.MultiTypeText;
import org.jpn.xucker.speech.multi.MultiTypeTextPlayer;
import org.jpn.xucker.speech.multi.PronounceConverter;

public class MbrolaJPPlayer
implements MultiTypeTextPlayer {
    public static Log log = LogFactory.getLog(MbrolaJPPlayer.class);
    private boolean enabled = true;
    private PronounceConverter pronounceConverter;
    private MbrolaJP mbrolaJP;
    boolean playing = false;
    boolean stopper;
    private File tmp;

    public MbrolaJP getMbrolaJP() {
        return this.mbrolaJP;
    }

    public void setMbrolaJP(MbrolaJP mbrolaJP) {
        this.mbrolaJP = mbrolaJP;
    }

    @Override
    public boolean available(MultiTypeText text) {
        boolean ret = this.enabled && text.getType().equals("jp");
        log.trace((Object)("" + ret));
        return ret;
    }

    @Override
    public void play(MultiTypeText multiTypeText) {
        if (this.playing) {
            return;
        }
        this.playing = true;
        String text = multiTypeText.getText();
        if (this.pronounceConverter != null) {
            text = this.pronounceConverter.convert(text);
        }
        if (text.length() == 0) {
            return;
        }
        try {
            this.tmp = File.createTempFile("tmp", ".wav");
            this.mbrolaJP.speak(this.tmp, text);
            this.stopper = false;
            this.play(this.tmp);
            this.playing = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(MultiTypeText multiTypeText, File file) {
        if (this.playing) {
            return;
        }
        this.playing = true;
        String text = multiTypeText.getText();
        if (this.pronounceConverter != null) {
            text = this.pronounceConverter.convert(text);
        }
        if (text.length() == 0) {
            return;
        }
        try {
            this.mbrolaJP.speak(file, text);
            this.playing = false;
            this.stopper = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cancel() {
        this.mbrolaJP.cancel();
        this.stopper = true;
        this.deleteTmp();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bool) {
        this.enabled = bool;
    }

    public PronounceConverter getPronounceConverter() {
        return this.pronounceConverter;
    }

    public void setPronounceConverter(PronounceConverter pronounceConverter) {
        this.pronounceConverter = pronounceConverter;
    }

    public void play(File file) {
        try {
            AudioInputStream inputStream = AudioSystem.getAudioInputStream(file);
            AudioFormat format = inputStream.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
            line.start();
            int readBytes = 0;
            byte[] bytedata = new byte[256];
            while (readBytes != -1) {
                if (this.stopper) break;
                readBytes = inputStream.read(bytedata, 0, bytedata.length);
                if (readBytes < 0) continue;
                line.write(bytedata, 0, readBytes);
            }
            line.drain();
            line.close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteTmp() {
        if (this.tmp != null) {
            this.tmp.delete();
            this.tmp = null;
        }
    }

    @Override
    public void dispose() {
    }
}

