/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.speech.multi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jpn.xucker.rcp.audio.AudioConverter;
import org.jpn.xucker.rcp.audio.AudioSetting;
import org.jpn.xucker.rcp.speech.AudioConverterBuilder;
import org.jpn.xucker.rcp.speech.AudioUtils;
import org.jpn.xucker.rcp.speech.SpeechPlugin;
import org.jpn.xucker.speech.multi.MultiTypeText;
import org.jpn.xucker.speech.multi.MultiTypeTextPlayer;
import org.jpn.xucker.speech.multi.MultiTypeTextSpeechListener;
import org.jpn.xucker.speech.multi.MultiTypeTextSplitter;

public class MultiTypeTextSpeech {
    public static Log log = LogFactory.getLog(MultiTypeTextSpeech.class);
    List playerList = new ArrayList();
    private MultiTypeTextSplitter spliter;
    boolean playing;
    boolean stopping;
    MultiTypeTextPlayer currentPlayer;
    List listenerList = new ArrayList();

    public void addPlayer(MultiTypeTextPlayer player) {
        this.playerList.add(player);
    }

    public void removePlayer(MultiTypeTextPlayer player) {
        this.playerList.remove(player);
    }

    public MultiTypeTextPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(MultiTypeTextPlayer currentPlayer) {
        this.currentPlayer = currentPlayer;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
    }

    public MultiTypeTextSplitter getSpliter() {
        return this.spliter;
    }

    public void setSpliter(MultiTypeTextSplitter spliter) {
        this.spliter = spliter;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    public void addMultiTypeSpeechListener(MultiTypeTextSpeechListener listener) {
        this.listenerList.add(listener);
    }

    public void removeMultiTypeSpeechListener(MultiTypeTextSpeechListener listener) {
        this.listenerList.remove(listener);
    }

    public void play(String text) {
        log.info((Object)"call play");
        if (!this.playing) {
            Play play = new Play(text);
            play.start();
        }
    }

    public AudioFormat getExportPCMAudioFileFormat() {
        int tmpquality;
        int tmpsamplerate;
        int tmpchannel;
        int samplebit = 16;
        int channel = 2;
        int samplerate = 44100;
        String type = SpeechPlugin.getDefault().getPreferenceStore().getString("export.type");
        IPreferenceStore store = SpeechPlugin.getDefault().getPreferenceStore();
        int tmpsamplebit = store.getInt("export." + type.toLowerCase() + ".samplebit");
        if (tmpsamplebit > 0) {
            samplebit = tmpsamplebit;
        }
        if ((tmpchannel = store.getInt("export." + type.toLowerCase() + ".channel")) > 0) {
            channel = tmpchannel;
        }
        if ((tmpsamplerate = store.getInt("export." + type.toLowerCase() + ".samplerate")) > 0) {
            samplerate = tmpsamplerate;
        }
        if ((tmpquality = store.getInt("export." + type.toLowerCase() + ".quality")) > 0) {
        }
        boolean signed = true;
        if (samplebit == 8) {
            signed = false;
        }
        AudioFormat format = new AudioFormat(samplerate, samplebit, channel, signed, false);
        return format;
    }

    public AudioSetting getExportAudioSetting(String type) {
        int tmpquality;
        int tmpsamplerate;
        int tmpchannel;
        int samplebit = 16;
        int channel = 2;
        int samplerate = 44100;
        int quality = 50;
        IPreferenceStore store = SpeechPlugin.getDefault().getPreferenceStore();
        int tmpsamplebit = store.getInt("export." + type.toLowerCase() + ".samplebit");
        if (tmpsamplebit > 0) {
            samplebit = tmpsamplebit;
        }
        if ((tmpchannel = store.getInt("export." + type.toLowerCase() + ".channel")) > 0) {
            channel = tmpchannel;
        }
        if ((tmpsamplerate = store.getInt("export." + type.toLowerCase() + ".samplerate")) > 0) {
            samplerate = tmpsamplerate;
        }
        if ((tmpquality = store.getInt("export." + type.toLowerCase() + ".quality")) > 0) {
            quality = tmpquality;
        }
        AudioSetting setting = new AudioSetting();
        setting.setSamplerate(samplerate);
        setting.setChannel(channel);
        setting.setSamplebit(samplebit);
        setting.setQuality(quality);
        return setting;
    }

    public void mixFile(File output, File[] files) {
        try {
            String type = SpeechPlugin.getDefault().getPreferenceStore().getString("export.type");
            AudioFormat format = this.getExportPCMAudioFileFormat();
            log.trace((Object)("exportAudio-pcm:" + format));
            log.trace((Object)("type:" + type));
            if (this.isWaveFile(output)) {
                AudioUtils.mixFile(output, files, AudioFileFormat.Type.WAVE, format);
            } else {
                File tmp = new File("out.wav");
                AudioConverter converter = AudioConverterBuilder.getConvert(tmp, output);
                if (converter != null) {
                    String extension = org.jpn.xucker.rcp.audio.AudioUtils.getExtension((File)output);
                    AudioSetting exportSetting = this.getExportAudioSetting(extension);
                    if (exportSetting == null) {
                        log.warn((Object)("exportSetting is null:" + extension));
                    }
                    log.trace((Object)("export-setting:" + exportSetting));
                    tmp = File.createTempFile("out", ".wav");
                    log.trace((Object)("mix-tmp:" + tmp.getAbsolutePath()));
                    AudioUtils.mixFile(tmp, files, AudioFileFormat.Type.WAVE, format);
                    log.trace((Object)("convert:" + converter));
                    log.trace((Object)("output:" + output));
                    converter.convert(tmp, output, exportSetting, null);
                    tmp.delete();
                } else {
                    log.warn((Object)"not found supported file");
                }
            }
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isWaveFile(File output) {
        return output.getName().toLowerCase().endsWith(".wav");
    }

    public void write(File file, String text) throws IOException {
        if (!this.playing) {
            Write write = new Write(file, text);
            write.start();
        }
    }

    public void write(File[] file, String[] text) throws IOException {
        if (!this.playing) {
            MultiWrite write = new MultiWrite(file, text);
            write.start();
        }
    }

    public void cancel() {
        this.stopping = true;
        if (this.currentPlayer != null) {
            this.currentPlayer.cancel();
        }
        this.playing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCancel() {
        MultiTypeTextSpeechListener[] listener;
        MultiTypeTextSpeech multiTypeTextSpeech = this;
        synchronized (multiTypeTextSpeech) {
            listener = this.listenerList.toArray(new MultiTypeTextSpeechListener[this.listenerList.size()]);
        }
        int i = 0;
        while (i < listener.length) {
            listener[i].cancel();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStart() {
        MultiTypeTextSpeechListener[] listener;
        MultiTypeTextSpeech multiTypeTextSpeech = this;
        synchronized (multiTypeTextSpeech) {
            listener = this.listenerList.toArray(new MultiTypeTextSpeechListener[this.listenerList.size()]);
        }
        int i = 0;
        while (i < listener.length) {
            listener[i].playStart();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFinish() {
        MultiTypeTextSpeechListener[] listener;
        MultiTypeTextSpeech multiTypeTextSpeech = this;
        synchronized (multiTypeTextSpeech) {
            listener = this.listenerList.toArray(new MultiTypeTextSpeechListener[this.listenerList.size()]);
        }
        int i = 0;
        while (i < listener.length) {
            listener[i].playFinish();
            ++i;
        }
    }

    public class MultiWrite
    extends Thread {
        private String[] texts;
        private File[] files;

        public MultiWrite(File[] files, String[] texts) {
            this.texts = texts;
            this.files = files;
            if (texts.length != files.length) {
                log.warn((Object)"valid length");
            }
        }

        @Override
        public void run() {
            log.trace((Object)"multi-write");
            MultiTypeTextSpeech.this.stopping = false;
            MultiTypeTextSpeech.this.playing = true;
            MultiTypeTextSpeech.this.fireStart();
            int k = 0;
            while (k < this.texts.length) {
                File file = this.files[k];
                String text = this.texts[k];
                log.trace((Object)("file:" + file.getAbsolutePath()));
                MultiTypeText[] texts = MultiTypeTextSpeech.this.spliter.split(text);
                MultiTypeTextPlayer[] players = MultiTypeTextSpeech.this.playerList.toArray(new MultiTypeTextPlayer[MultiTypeTextSpeech.this.playerList.size()]);
                ArrayList<File> writeFileList = new ArrayList<File>();
                int i = 0;
                while (i < texts.length) {
                    if (MultiTypeTextSpeech.this.stopping) {
                        MultiTypeTextSpeech.this.fireCancel();
                        File[] files = writeFileList.toArray(new File[writeFileList.size()]);
                        int j = 0;
                        while (j < files.length) {
                            files[j].delete();
                            ++j;
                        }
                        MultiTypeTextSpeech.this.playing = false;
                        return;
                    }
                    int j = 0;
                    while (j < players.length) {
                        if (players[j].available(texts[i])) {
                            MultiTypeTextSpeech.this.currentPlayer = players[j];
                            try {
                                File tmpFile = File.createTempFile("speech", ".wav");
                                players[j].write(texts[i], tmpFile);
                                writeFileList.add(tmpFile);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                File[] files = writeFileList.toArray(new File[writeFileList.size()]);
                MultiTypeTextSpeech.this.mixFile(file, files);
                ++k;
            }
            MultiTypeTextSpeech.this.playing = false;
            MultiTypeTextSpeech.this.fireFinish();
        }
    }

    public class Play
    extends Thread {
        private String text;

        public Play(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            log.trace((Object)("play:" + this.text));
            MultiTypeTextSpeech.this.stopping = false;
            MultiTypeTextSpeech.this.playing = true;
            MultiTypeTextSpeech.this.fireStart();
            MultiTypeText[] texts = MultiTypeTextSpeech.this.spliter.split(this.text);
            MultiTypeTextPlayer[] players = MultiTypeTextSpeech.this.playerList.toArray(new MultiTypeTextPlayer[MultiTypeTextSpeech.this.playerList.size()]);
            int i = 0;
            while (i < texts.length) {
                if (MultiTypeTextSpeech.this.stopping) {
                    MultiTypeTextSpeech.this.fireCancel();
                    return;
                }
                int j = 0;
                while (j < players.length) {
                    System.out.println(players.length);
                    if (players[j].available(texts[i])) {
                        MultiTypeTextSpeech.this.currentPlayer = players[j];
                        players[j].play(texts[i]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            MultiTypeTextSpeech.this.playing = false;
            MultiTypeTextSpeech.this.fireFinish();
        }
    }

    public class Write
    extends Thread {
        private String text;
        private File file;

        public Write(File file, String text) {
            this.text = text;
            this.file = file;
        }

        @Override
        public void run() {
            log.trace((Object)"write");
            log.trace((Object)("file:" + this.file.getAbsolutePath()));
            MultiTypeTextSpeech.this.stopping = false;
            MultiTypeTextSpeech.this.playing = true;
            MultiTypeTextSpeech.this.fireStart();
            MultiTypeText[] texts = MultiTypeTextSpeech.this.spliter.split(this.text);
            MultiTypeTextPlayer[] players = MultiTypeTextSpeech.this.playerList.toArray(new MultiTypeTextPlayer[MultiTypeTextSpeech.this.playerList.size()]);
            ArrayList<File> writeFileList = new ArrayList<File>();
            int i = 0;
            while (i < texts.length) {
                if (MultiTypeTextSpeech.this.stopping) {
                    MultiTypeTextSpeech.this.fireCancel();
                    File[] files = writeFileList.toArray(new File[writeFileList.size()]);
                    int j = 0;
                    while (j < files.length) {
                        files[j].delete();
                        ++j;
                    }
                    MultiTypeTextSpeech.this.playing = false;
                    return;
                }
                int j = 0;
                while (j < players.length) {
                    if (players[j].available(texts[i])) {
                        MultiTypeTextSpeech.this.currentPlayer = players[j];
                        try {
                            File tmpFile = File.createTempFile("speech", ".wav");
                            players[j].write(texts[i], tmpFile);
                            writeFileList.add(tmpFile);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            MultiTypeTextSpeech.this.playing = false;
            MultiTypeTextSpeech.this.fireFinish();
            File[] files = writeFileList.toArray(new File[writeFileList.size()]);
            MultiTypeTextSpeech.this.mixFile(this.file, files);
        }
    }
}

