/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.model.BuilderUtils;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsModelMessages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.registry.ExternalToolMigration;

public final class ExternalToolBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "org.eclipse.ui.externaltools.ExternalToolBuilder";
    private static final String BUILD_TYPE_SEPARATOR = ",";
    private static final int[] DEFAULT_BUILD_TYPES = new int[]{10, 6};
    private static String buildType = "none";
    private static IProject buildProject = null;
    private List projectsWithinScope;

    private boolean buildKindCompatible(int kind, ILaunchConfiguration config) throws CoreException {
        int[] buildKinds = ExternalToolBuilder.buildTypesToArray(config.getAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", ""));
        int j = 0;
        while (j < buildKinds.length) {
            if (kind == buildKinds[j]) {
                return true;
            }
            ++j;
        }
        return false;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (ExternalToolsPlugin.getDefault().getBundle().getState() != 32) {
            return null;
        }
        if (kind == 6) {
            ILaunchConfiguration config = BuilderUtils.configFromBuildCommandArgs(this.getProject(), args, new String[1]);
            if (config != null && this.buildKindCompatible(kind, config) && this.configEnabled(config)) {
                this.launchBuild(kind, config, monitor);
            }
            if (this.shouldForgetBuildState(args)) {
                this.forgetLastBuiltState();
            }
            return this.getProjectsWithinScope();
        }
        ICommand[] commands = this.getProject().getDescription().getBuildSpec();
        this.projectsWithinScope = new ArrayList();
        int i = 0;
        while (i < commands.length) {
            ILaunchConfiguration config;
            if (ID.equals(commands[i].getBuilderName()) && (config = BuilderUtils.configFromBuildCommandArgs(this.getProject(), commands[i].getArguments(), new String[1])) != null && this.buildKindCompatible(kind, config) && this.configEnabled(config)) {
                this.doBuildBasedOnScope(kind, config, monitor);
            }
            ++i;
        }
        return this.getProjectsWithinScope();
    }

    private boolean shouldForgetBuildState(Map args) throws CoreException {
        ICommand[] commands = this.getProject().getDescription().getBuildSpec();
        int currentBuilderIndex = -1;
        int i = 0;
        while (i < commands.length) {
            ICommand command = commands[i];
            if (ID.equals(command.getBuilderName())) {
                ILaunchConfiguration config;
                if (command.getArguments().equals(args)) {
                    if (i + 1 == commands.length) {
                        return false;
                    }
                    currentBuilderIndex = i;
                } else if (currentBuilderIndex > -1 && i > currentBuilderIndex && (config = BuilderUtils.configFromBuildCommandArgs(this.getProject(), command.getArguments(), new String[1])) != null && this.buildKindCompatible(6, config) && this.configEnabled(config)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean configEnabled(ILaunchConfiguration config) {
        try {
            return ExternalToolsUtil.isBuilderEnabled(config);
        }
        catch (CoreException e) {
            ExternalToolsPlugin.getDefault().log(e);
            return true;
        }
    }

    private IProject[] getProjectsWithinScope() {
        if (this.projectsWithinScope == null || this.projectsWithinScope.isEmpty()) {
            this.projectsWithinScope = null;
            return null;
        }
        return this.projectsWithinScope.toArray(new IProject[this.projectsWithinScope.size()]);
    }

    private void doBuildBasedOnScope(int kind, ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        boolean buildForChange = true;
        IResource[] resources = ExternalToolsUtil.getResourcesForBuildScope(config);
        if (resources != null && resources.length > 0) {
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                this.projectsWithinScope.add(resource.getProject());
                ++i;
            }
            buildForChange = this.buildScopeIndicatesBuild(resources);
        }
        if (buildForChange) {
            this.launchBuild(kind, config, monitor);
        }
    }

    private void launchBuild(int kind, ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(MessageFormat.format(ExternalToolsModelMessages.getString("ExternalToolBuilder.Running_{0}..._1"), config.getName()));
        this.buildStarted(kind);
        config = ExternalToolMigration.migrateRunInBackground(config);
        config.launch("run", monitor);
        this.buildEnded();
    }

    public static String getBuildType() {
        return buildType;
    }

    public static IProject getBuildProject() {
        return buildProject;
    }

    private void buildStarted(int buildKind) {
        switch (buildKind) {
            case 10: {
                buildType = "incremental";
                break;
            }
            case 6: {
                buildType = "full";
                break;
            }
            case 9: {
                buildType = "auto";
                break;
            }
            default: {
                buildType = "none";
            }
        }
        buildProject = this.getProject();
    }

    private void buildEnded() {
        buildType = "none";
        buildProject = null;
    }

    private boolean buildScopeIndicatesBuild(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            IResourceDelta delta = this.getDelta(resources[i].getProject());
            if (delta == null) {
                return true;
            }
            IPath path = resources[i].getProjectRelativePath();
            IResourceDelta change = delta.findMember(path);
            if (change != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int[] buildTypesToArray(String buildTypes) {
        if (buildTypes == null || buildTypes.length() == 0) {
            return DEFAULT_BUILD_TYPES;
        }
        int count = 0;
        boolean incremental = false;
        boolean full = false;
        boolean auto = false;
        StringTokenizer tokenizer = new StringTokenizer(buildTypes, BUILD_TYPE_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("incremental".equals(token)) {
                if (incremental) continue;
                incremental = true;
                ++count;
                continue;
            }
            if ("full".equals(token)) {
                if (full) continue;
                full = true;
                ++count;
                continue;
            }
            if (!"auto".equals(token) || auto) continue;
            auto = true;
            ++count;
        }
        int[] results = new int[count];
        count = 0;
        if (incremental) {
            results[count] = 10;
            ++count;
        }
        if (full) {
            results[count] = 6;
            ++count;
        }
        if (auto) {
            results[count] = 9;
            ++count;
        }
        return results;
    }
}

