/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.audio.splitter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.commons.audio.splitter.AudioCutter;
import org.jpn.xucker.commons.audio.splitter.StopperOfAudioCutter;

public class JavaSoundWaveAudioCutter
implements AudioCutter {
    public static Log log;
    private boolean useBuffer;
    StopperOfAudioCutter stopper;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.commons.audio.splitter.JavaSoundWaveAudioCutter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean isUseBuffer() {
        return this.useBuffer;
    }

    public void setUseBuffer(boolean useBuffer) {
        this.useBuffer = useBuffer;
    }

    private void insplit(long startmillisecond, long endmillisecond, File inputFile, OutputStream output) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream = null;
        log.trace((Object)("inputFile:" + inputFile));
        audioInputStream = AudioSystem.getAudioInputStream(inputFile);
        AudioFormat format = audioInputStream.getFormat();
        log.trace((Object)("format:" + format));
        long startByte = WaveUtils.countByteAt(format, startmillisecond);
        long endByte = WaveUtils.countByteAt(format, endmillisecond);
        long playByte = endByte - startByte;
        if (log.isTraceEnabled()) {
            log.trace((Object)("start:" + startByte));
            log.trace((Object)("end:" + endByte));
            log.trace((Object)("play:" + playByte));
            log.trace((Object)("bit:" + (float)(format.getChannels() * (format.getSampleSizeInBits() / 8)) * format.getFrameRate()));
        }
        audioInputStream.skip(startByte);
        int readBytes = 0;
        byte[] bytedata = new byte[1028];
        long readedByte = 0L;
        while (readBytes != -1) {
            if (this.stopper != null && this.stopper.isStopped()) {
                audioInputStream.close();
                return;
            }
            readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
            if (readBytes < 0) continue;
            if (readedByte + (long)readBytes >= playByte) {
                output.write(bytedata, 0, Math.min((int)(playByte - readedByte), readBytes));
                break;
            }
            output.write(bytedata, 0, readBytes);
            readedByte += (long)readBytes;
        }
        audioInputStream.close();
    }

    private void insplit(long startmillisecond, long endmillisecond, InputStream input, OutputStream output) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream = null;
        audioInputStream = AudioSystem.getAudioInputStream(input);
        AudioFormat format = audioInputStream.getFormat();
        long startByte = WaveUtils.countByteAt(format, startmillisecond);
        long endByte = WaveUtils.countByteAt(format, endmillisecond);
        long playByte = endByte - startByte;
        if (log.isTraceEnabled()) {
            log.trace((Object)("start:" + startByte));
            log.trace((Object)("end:" + endByte));
            log.trace((Object)("play:" + playByte));
            log.trace((Object)("bit:" + (float)(format.getChannels() * format.getSampleSizeInBits()) * format.getFrameRate()));
        }
        audioInputStream.skip(startByte);
        int readBytes = 0;
        byte[] bytedata = new byte[1028];
        long readedByte = 0L;
        while (readBytes != -1) {
            if (this.stopper != null && this.stopper.isStopped()) {
                audioInputStream.close();
                return;
            }
            readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
            if (readBytes < 0) continue;
            if (readedByte + (long)readBytes >= playByte) {
                output.write(bytedata, 0, Math.min((int)(playByte - readedByte), readBytes));
                break;
            }
            output.write(bytedata, 0, readBytes);
            readedByte += (long)readBytes;
        }
        audioInputStream.close();
    }

    private void splitFileBuffer(long startmillisecond, long endmillisecond, File inputFile, File outputFile) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            FileInputStream input = new FileInputStream(inputFile);
            this.insplit(startmillisecond, endmillisecond, inputFile, (OutputStream)bout);
            bout.close();
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputFile);
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioInputStream clipInput = new AudioInputStream(new ByteArrayInputStream(bout.toByteArray()), audioFormat, bout.size() / audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8);
            FileOutputStream output = new FileOutputStream(outputFile);
            int writtenBytes = -1;
            writtenBytes = AudioSystem.write(clipInput, AudioFileFormat.Type.WAVE, output);
            log.trace((Object)("write:" + writtenBytes));
            clipInput.close();
            output.close();
        }
        catch (UnsupportedAudioFileException e) {
            log.fatal((Object)"", (Throwable)e);
        }
    }

    public void cut(File inputFile, long startmillisecond, long endmillisecond, File outputFile) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("cut:" + startmillisecond + "," + endmillisecond + "," + inputFile.getAbsolutePath() + "," + outputFile.getAbsolutePath()));
        }
        if (this.useBuffer) {
            this.splitFileBuffer(startmillisecond, endmillisecond, inputFile, outputFile);
        } else {
            this.splitFileTmpFile(startmillisecond, endmillisecond, inputFile, outputFile);
        }
    }

    public void cut(File inputFile, long[] startmillisecond, long[] endmillisecond, File[] outputFile) throws IOException {
        int i = 0;
        while (i < startmillisecond.length) {
            if (this.stopper != null && this.stopper.isStopped()) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)(String.valueOf(startmillisecond[i]) + "," + endmillisecond[i] + "," + inputFile.getAbsolutePath() + "," + outputFile[i].getAbsolutePath()));
            }
            if (this.useBuffer) {
                this.splitFileBuffer(startmillisecond[i], endmillisecond[i], inputFile, outputFile[i]);
            } else {
                this.splitFileTmpFile(startmillisecond[i], endmillisecond[i], inputFile, outputFile[i]);
            }
            ++i;
        }
    }

    private void splitFileTmpFile(long startmillisecond, long endmillisecond, File inputFile, File outputFile) throws IOException {
        try {
            File tmpFile = File.createTempFile("wavsplitter", ".wav");
            log.trace((Object)("create tmp:" + tmpFile.getAbsolutePath()));
            FileOutputStream fout = new FileOutputStream(tmpFile);
            FileInputStream input = new FileInputStream(inputFile);
            this.insplit(startmillisecond, endmillisecond, inputFile, (OutputStream)fout);
            fout.close();
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputFile);
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioInputStream clipInput = new AudioInputStream(new FileInputStream(tmpFile), audioFormat, tmpFile.length() / (long)audioFormat.getChannels() * (long)audioFormat.getSampleSizeInBits() / 8L);
            FileOutputStream output = new FileOutputStream(outputFile);
            int writtenBytes = -1;
            writtenBytes = AudioSystem.write(clipInput, AudioFileFormat.Type.WAVE, output);
            log.trace((Object)("write:" + writtenBytes));
            clipInput.close();
            output.close();
            boolean result = tmpFile.delete();
            log.trace((Object)("delte tmp:" + result));
        }
        catch (UnsupportedAudioFileException e) {
            log.fatal((Object)"", (Throwable)e);
        }
    }

    public void setStopper(StopperOfAudioCutter stopper) {
        this.stopper = stopper;
    }
}

