/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.mp3;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.splitter.AudioCutter;
import org.jpn.xucker.commons.audio.splitter.StopperOfAudioCutter;
import org.jpn.xucker.mp3.MP3Utils;

public class JavaLayerMP3Cutter
implements AudioCutter {
    public static Log log;
    StopperOfAudioCutter stopper;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.mp3.JavaLayerMP3Cutter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void cut(File inputFile, long startmillisecond, long endmillisecond, File outputFile) throws IOException {
        this.cut(inputFile, new long[]{startmillisecond}, new long[]{endmillisecond}, new File[]{outputFile});
    }

    public void cut(File inputFile, long[] startmillisecond, long[] endmillisecond, File[] outputFile) throws IOException {
        if (this.stopper != null && this.stopper.isStopped()) {
            log.trace((Object)"stop");
            return;
        }
        int id3v2_headersize = 0;
        long start = 0L;
        long end = 0L;
        long playByte = 0L;
        int bps = 0;
        try {
            FileInputStream finput = new FileInputStream(inputFile);
            Bitstream stream = new Bitstream((InputStream)finput);
            id3v2_headersize = stream.header_pos();
            Header header = stream.readFrame();
            bps = header.bitrate();
            stream.close();
        }
        catch (BitstreamException e) {
            e.printStackTrace();
            return;
        }
        int i = 0;
        while (i < startmillisecond.length) {
            start = MP3Utils.calculateByteAt(bps, startmillisecond[i]);
            end = MP3Utils.calculateByteAt(bps, endmillisecond[i]);
            playByte = end - start;
            log.trace((Object)("start:" + start + " end:" + end + " play:" + playByte));
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(outputFile[i]));
            BufferedInputStream binput = new BufferedInputStream(new FileInputStream(inputFile));
            binput.skip(id3v2_headersize);
            binput.skip(start);
            int readBytes = 0;
            int buffersize = 1024;
            byte[] bytedata = new byte[buffersize];
            long readedByte = 0L;
            while (readBytes != -1) {
                if (this.stopper != null && this.stopper.isStopped()) {
                    log.info((Object)"stopper stop");
                    binput.close();
                    bout.close();
                    return;
                }
                readBytes = binput.read(bytedata, 0, bytedata.length);
                if (readBytes < 0) continue;
                if (readedByte + (long)readBytes < playByte) {
                    bout.write(bytedata, 0, readBytes);
                    readedByte += (long)readBytes;
                    continue;
                }
                int value = Math.min((int)(playByte - readedByte), readBytes);
                bout.write(bytedata, 0, value);
                readedByte += (long)value;
                break;
            }
            log.trace((Object)("readed:" + readedByte));
            binput.close();
            bout.close();
            ++i;
        }
    }

    public void setStopper(StopperOfAudioCutter stopper) {
        this.stopper = stopper;
    }
}

