/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.mp3;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.splitter.StopperOfAudioCutter;

public class MP3SearchTime {
    List vList = new Vector(102400);
    private int skipbyte;
    private int frequency;
    private File file;
    private float ms_per_frame;
    private boolean doBalance;
    public static Log log;
    private int addsample;
    StopperOfAudioCutter stopper;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.mp3.MP3SearchTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean isDoBalance() {
        return this.doBalance;
    }

    public void setDoBalance(boolean doBalance) {
        this.doBalance = doBalance;
    }

    public MP3SearchTime(File mp3File) throws IOException {
        this.file = mp3File;
        Bitstream stream = new Bitstream((InputStream)new FileInputStream(mp3File));
        this.skipbyte = stream.header_pos();
        Header header = null;
        try {
            header = stream.readFrame();
            if (header.version() == 2) {
                log.trace((Object)"version 2.5");
                this.addsample = 576;
            } else {
                this.addsample = 1152;
            }
            log.trace((Object)("framesize:" + header.calculate_framesize()));
            stream.unreadFrame();
        }
        catch (BitstreamException e2) {
            e2.printStackTrace();
        }
        long currentsamples = 0L;
        this.frequency = header.frequency();
        this.ms_per_frame = header.ms_per_frame();
        long frame = 0L;
        while (true) {
            try {
                header = stream.readFrame();
                if (header == null) break;
                this.vList.add(new Integer(header.calculate_framesize()));
                stream.closeFrame();
                ++frame;
            }
            catch (BitstreamException e) {
                e.printStackTrace();
            }
        }
        log.trace((Object)("fames:" + frame));
        try {
            stream.close();
        }
        catch (BitstreamException e) {
            e.printStackTrace();
        }
    }

    public long findByte(long time) throws IOException {
        int b;
        if (time == 0L) {
            log.trace((Object)"call 0");
            return 0L;
        }
        long result = -1L;
        FileInputStream binput = new FileInputStream(this.file);
        binput.skip(this.skipbyte);
        boolean F = false;
        int index = 0;
        log.trace((Object)("fraquency:" + this.frequency));
        long targetsamples = time * (long)this.frequency / 1000L;
        if (this.doBalance) {
            targetsamples -= (long)(this.addsample / 2);
        }
        log.trace((Object)("target " + targetsamples));
        long currentsample = 0L;
        long readed = this.skipbyte;
        log.trace((Object)("skip:" + readed));
        long pre = 0L;
        long b1 = 0L;
        while ((b = binput.read()) != -1) {
            ++readed;
            ++b1;
            if (F) {
                if (b >= 224) {
                    if (this.stopper != null && this.stopper.isStopped()) {
                        log.info((Object)"canceld");
                        return -1L;
                    }
                    if ((currentsample += (long)this.addsample) > targetsamples) {
                        binput.close();
                        log.trace((Object)("current sample:" + currentsample));
                        log.trace((Object)("index:" + (index + 1)));
                        log.trace((Object)("" + this.ms_per_frame * (float)(index + 1)));
                        int tmp = (Integer)this.vList.get(index);
                        log.trace((Object)("" + (readed + 2L + (long)tmp)));
                        return readed + 2L + (long)tmp;
                    }
                    F = false;
                    if (index >= this.vList.size()) {
                        log.warn((Object)("over length:" + index));
                        return -1L;
                    }
                    int tmpSkip = (Integer)this.vList.get(index);
                    binput.skip(tmpSkip + 2);
                    readed += (long)(tmpSkip + 2);
                    ++index;
                    if (b1 > 2L) {
                        log.trace((Object)(readed + "," + (readed - pre) + "," + (b1 - 2L)));
                    }
                    b1 = 0L;
                    continue;
                }
                F = false;
                continue;
            }
            if (b != 255) continue;
            F = true;
        }
        log.trace((Object)("last:" + index));
        return result;
    }

    public void setStopper(StopperOfAudioCutter stopper) {
        this.stopper = stopper;
    }
}

