/*
 * Decompiled with CFR 0.152.
 */
package RcpSen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.java.sen.StringTagger;
import net.java.sen.Token;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringTaggerTools {
    Log log;
    StringTagger tagger;
    public static final String READING = "reading";
    public static final String PRONUNCIATION = "pronunciation";
    public static final String BASE = "base";
    private boolean importSplitSpace;
    public static final String MARU = "\u3002";
    public static final String TEN = "\u3001";
    static /* synthetic */ Class class$0;

    public StringTaggerTools(StringTagger tagger) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("RcpSen.StringTaggerTools");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.importSplitSpace = true;
        this.tagger = tagger;
    }

    public String[] split(String text, int maxlength, String type) throws IOException {
        ArrayList<String> textList = new ArrayList<String>();
        Token[] tokens = this.tagger.analyze(text);
        new StringBuffer();
        if (this.getPronunciationLength(tokens) < maxlength) {
            textList.add(this.mixString(tokens, type));
        } else {
            List maruList = this.splitMaru(tokens);
            int i = 0;
            while (i < maruList.size()) {
                Token[] maruTokens = (Token[])maruList.get(i);
                if (this.getPronunciationLength(maruTokens) < maxlength) {
                    textList.add(this.mixString(maruTokens, type));
                } else {
                    List tenList = this.splitTen(maruTokens);
                    int j = 0;
                    while (j < tenList.size()) {
                        Token[] tenTokens = (Token[])tenList.get(j);
                        if (this.getPronunciationLength(tenTokens) < maxlength) {
                            textList.add(this.mixString(tenTokens, type));
                        } else {
                            List tokenList = this.splitToken(tenTokens, maxlength);
                            int k = 0;
                            while (k < tokenList.size()) {
                                Token[] tokengroup = (Token[])tokenList.get(k);
                                String space = "";
                                if (this.importSplitSpace) {
                                    space = " ";
                                }
                                textList.add(String.valueOf(this.mixString(tokengroup, type)) + space);
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return textList.toArray(new String[textList.size()]);
    }

    public List splitMaru(Token[] tokens) {
        ArrayList<Token[]> tokenList = new ArrayList<Token[]>();
        ArrayList<Token> tmpList = new ArrayList<Token>();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].toString().equals(MARU)) {
                tmpList.add(tokens[i]);
                tokenList.add(tmpList.toArray(new Token[tmpList.size()]));
                tmpList.removeAll(tmpList);
            } else {
                tmpList.add(tokens[i]);
            }
            ++i;
        }
        if (tmpList.size() > 0) {
            tokenList.add(tmpList.toArray(new Token[tmpList.size()]));
        }
        return tokenList;
    }

    public List splitTen(Token[] tokens) {
        ArrayList<Token[]> tokenList = new ArrayList<Token[]>();
        ArrayList<Token> tmpList = new ArrayList<Token>();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].toString().equals(TEN)) {
                tmpList.add(tokens[i]);
                tokenList.add(tmpList.toArray(new Token[tmpList.size()]));
                tmpList.removeAll(tmpList);
            } else {
                tmpList.add(tokens[i]);
            }
            ++i;
        }
        if (tmpList.size() > 0) {
            tokenList.add(tmpList.toArray(new Token[tmpList.size()]));
        }
        return tokenList;
    }

    public List splitToken(Token[] tokens, int maxlength) {
        ArrayList<Token[]> tokenList = new ArrayList<Token[]>();
        ArrayList<Token> tmpList = new ArrayList<Token>();
        int current = 0;
        int i = 0;
        while (i < tokens.length) {
            this.log.trace((Object)tokens[i]);
            int length = this.getPronunciationLength(tokens[i]);
            if (current + length > maxlength) {
                if (tmpList.size() > 0) {
                    tokenList.add(tmpList.toArray(new Token[tmpList.size()]));
                    tmpList.removeAll(tmpList);
                }
                current = length;
            } else {
                current += length;
            }
            tmpList.add(tokens[i]);
            ++i;
        }
        if (tmpList.size() > 0) {
            tokenList.add(tmpList.toArray(new Token[tmpList.size()]));
        }
        return tokenList;
    }

    public String mixString(Token[] tokens, String type) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            String value = null;
            value = type == READING ? tokens[i].getReading() : (type == PRONUNCIATION ? tokens[i].getPronunciation() : tokens[i].toString());
            if (value == null) {
                value = tokens[i].toString();
            }
            result.append(value);
            ++i;
        }
        return result.toString();
    }

    public int getPronunciationLength(Token token) {
        if (token.getPronunciation() != null) {
            return token.getPronunciation().length();
        }
        return token.toString().length();
    }

    private int getPronunciationLength(Token[] tokens) {
        int kanalength = 0;
        int i = 0;
        while (i < tokens.length) {
            kanalength = tokens[i].getPronunciation() != null ? (kanalength += tokens[i].getPronunciation().length()) : (kanalength += tokens[i].toString().length());
            ++i;
        }
        return kanalength;
    }

    public String getReading(String text) throws IOException {
        Token[] tokens = this.tagger.analyze(text);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            String value = tokens[i].getReading();
            if (value == null) {
                value = tokens[i].toString();
            }
            result.append(value);
            ++i;
        }
        return result.toString();
    }

    public String getPronunciation(String text) throws IOException {
        Token[] tokens = this.tagger.analyze(text);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            String value = tokens[i].getPronunciation();
            if (value == null) {
                value = tokens[i].toString();
            }
            result.append(value);
            ++i;
        }
        return result.toString();
    }

    public String getWakati(String text) throws IOException {
        Token[] tokens = this.tagger.analyze(text);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            result.append(tokens[i].toString());
            result.append(" ");
            ++i;
        }
        return result.toString().substring(0, result.length() - 1);
    }

    public boolean isImportSplitSpace() {
        return this.importSplitSpace;
    }

    public void setImportSplitSpace(boolean importSplitSpace) {
        this.importSplitSpace = importSplitSpace;
    }
}

