/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh2;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.ssh.SSHServerConnection;
import org.eclipse.team.internal.ccvs.ssh2.JSchSession;
import org.eclipse.team.internal.ccvs.ssh2.Policy;
import org.eclipse.team.internal.core.streams.PollingInputStream;
import org.eclipse.team.internal.core.streams.PollingOutputStream;
import org.eclipse.team.internal.core.streams.TimeoutInputStream;
import org.eclipse.team.internal.core.streams.TimeoutOutputStream;

public class CVSSSH2ServerConnection
implements IServerConnection {
    private static final String COMMAND = "cvs server";
    private ICVSRepositoryLocation location;
    private String password;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Session session;
    private Channel channel;
    private IServerConnection ssh1;

    protected CVSSSH2ServerConnection(ICVSRepositoryLocation location, String password) {
        this.location = location;
        this.password = password;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        if (this.ssh1 != null) {
            this.ssh1.close();
            this.ssh1 = null;
            return;
        }
        try {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException v0) {}
            }
            var1_3 = null;
            ** GOTO lbl22
        }
        catch (Throwable var2_1) {
            var1_2 = null;
            try {
                block15: {
                    block16: {
                        if (this.outputStream == null) break block16;
                        try {
                            this.outputStream.close();
lbl22:
                            // 1 sources

                            ** try [egrp 2[TRYBLOCK] [4 : 50->71)] { 
lbl23:
                            // 1 sources

                            if (this.outputStream != null) {
                                ** try [egrp 3[TRYBLOCK] [3 : 57->67)] { 
lbl25:
                                // 1 sources

                                this.outputStream.close();
                            }
                            break block15;
                        }
                        catch (IOException v1) {}
                    }
                    v2 = null;
                    ** GOTO lbl38
lbl32:
                    // 1 sources

                    catch (IOException v3) {}
                }
                v4 = null;
                ** GOTO lbl44
            }
            catch (Throwable var4_4) {
                v2 = null;
lbl38:
                // 2 sources

                var3_6 = v2;
                if (this.channel == null) throw var2_1;
                this.channel.disconnect();
                throw var2_1;
            }
        }
lbl42:
        // 1 sources

        catch (Throwable var4_5) {
            v4 = null;
lbl44:
            // 2 sources

            var3_7 = v4;
            if (this.channel == null) return;
            this.channel.disconnect();
            return;
        }
    }

    public InputStream getInputStream() {
        if (this.ssh1 != null) {
            return this.ssh1.getInputStream();
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        if (this.ssh1 != null) {
            return this.ssh1.getOutputStream();
        }
        return this.outputStream;
    }

    public void open(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        if (this.ssh1 != null) {
            this.ssh1.open(monitor);
            return;
        }
        monitor.subTask(Policy.bind("CVSSSH2ServerConnection.open", this.location.getHost()));
        monitor.worked(1);
        this.internalOpen(monitor);
    }

    private void internalOpen(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        try {
            InputStream channel_in;
            OutputStream channel_out;
            String hostname = this.location.getHost();
            String username = this.location.getUsername();
            int port = this.location.getPort();
            if (port == 0) {
                port = 0;
            }
            int retry = 1;
            while (true) {
                this.session = JSchSession.getSession(this.location, username, this.password, hostname, port, new JSchSession.ResponsiveSocketFacory(monitor));
                this.channel = this.session.openChannel("exec");
                ((ChannelExec)this.channel).setCommand(COMMAND);
                channel_out = this.channel.getOutputStream();
                channel_in = this.channel.getInputStream();
                try {
                    this.channel.connect();
                }
                catch (JSchException jSchException) {
                    if (--retry < 0) {
                        throw new CVSAuthenticationException(Policy.bind("CVSSSH2ServerConnection.3"), 2);
                    }
                    if (!this.session.isConnected()) continue;
                    this.session.disconnect();
                    continue;
                }
                break;
            }
            int timeout = this.location.getTimeout();
            this.inputStream = new PollingInputStream((InputStream)new TimeoutInputStream((InputStream)new FilterInputStream(channel_in){

                public void close() throws IOException {
                }
            }, 8192, 1000L, -1L, true), timeout > 0 ? timeout : 1, monitor);
            this.outputStream = new PollingOutputStream((OutputStream)new TimeoutOutputStream((OutputStream)new FilterOutputStream(channel_out){

                public void close() throws IOException {
                }
            }, 8192, 1000L, 1000L), timeout > 0 ? timeout : 1, monitor);
        }
        catch (JSchException e) {
            if (e.toString().indexOf("invalid server's version string") == -1) {
                throw new CVSAuthenticationException(e.toString(), 2);
            }
            this.ssh1 = new SSHServerConnection(this.location, this.password);
            if (this.ssh1 == null) {
                throw new CVSAuthenticationException(e.toString(), 2);
            }
            this.ssh1.open(monitor);
        }
    }
}

