/*
 * Decompiled with CFR 0.152.
 */
package rcp_gtalk.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import rcp_gtalk.Gtalk;
import rcp_gtalk.GtalkPlugin;
import rcp_gtalk.views.GtalkSpeakerSettingView;
import rcp_gtalk.views.GtalkView;

public class GtalkAction
implements IViewActionDelegate {
    private IViewPart view;
    private static final String ACTION_PLAY = "rcp_gtalk.actions.play";
    private static final String ACTION_STOP = "rcp_gtalk.actions.stop";
    private static final String ACTION_WRITE = "rcp_gtalk.actions.write";
    private IWorkbenchWindow window;
    private Gtalk gtalk;

    public void run(IAction action) {
        GtalkView gtalkView = (GtalkView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(GtalkView.ID_VIEW);
        GtalkSpeakerSettingView settingView = (GtalkSpeakerSettingView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(GtalkSpeakerSettingView.ID_VIEW);
        this.gtalk = settingView != null ? settingView.getGtalk() : new Gtalk();
        System.out.println(this.gtalk);
        this.gtalk.setGtalkBaseDir(GtalkPlugin.getDefault().getGtalkDirectory().getAbsolutePath());
        this.gtalk.setGtalkSettringPath(String.valueOf(GtalkPlugin.getDefault().getGtalkDirectory().getAbsolutePath()) + File.separator + "ssm.conf");
        System.out.println(String.valueOf(this.gtalk.getGtalkBaseDir()) + "," + this.gtalk.getGtalkSettringPath());
        if (action.getId().equals(ACTION_PLAY)) {
            new GtalkPlayer(this.fixText(gtalkView.getInputArea().getText())).start();
        } else if (action.getId().equals(ACTION_STOP)) {
            this.gtalk.cancel();
        } else if (action.getId().equals(ACTION_WRITE)) {
            try {
                FileDialog dialog = new FileDialog(this.view.getViewSite().getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.wav"});
                dialog.setFilterNames(new String[]{"WAVE Audio File (*.wav)"});
                String path = dialog.open();
                File file = new File(path);
                File tmp = File.createTempFile("gtalk", ".raw");
                this.gtalk.writeRaw(this.fixText(gtalkView.getInputArea().getText()), tmp);
                AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, false);
                Gtalk.log.trace((Object)("file-length:" + tmp.length()));
                AudioInputStream inputStream = new AudioInputStream(new FileInputStream(tmp), format, tmp.length() / 2L);
                FileOutputStream output = new FileOutputStream(file);
                long writtenBytes = AudioSystem.write(inputStream, AudioFileFormat.Type.WAVE, output);
                Gtalk.log.trace((Object)("writebyte:" + writtenBytes));
                inputStream.close();
                output.flush();
                output.close();
                boolean result = tmp.delete();
                Gtalk.log.trace((Object)("tmp delete:" + result));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String fixText(String text) {
        String result = text.replaceAll("\n", "");
        result = result.replaceAll("\r", "");
        return result;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
        this.view = view;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public class GtalkPlayer
    extends Thread {
        private String gtalkText;

        public GtalkPlayer(String text) {
            this.gtalkText = text;
        }

        public void run() {
            try {
                GtalkAction.this.gtalk.play(this.gtalkText);
            }
            catch (IOException e) {
                Gtalk.log.warn((Object)e);
            }
        }
    }
}

