/*
 * Decompiled with CFR 0.152.
 */
package rcp_gtalk.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import rcp_gtalk.Gtalk;
import rcp_gtalk.views.GtalkView;

public class GtalkTagAction
implements IViewActionDelegate {
    private IViewPart view;
    private static final String ACTION_SILENCE = "rcp_gtalk.actions.silence";
    private static final String ACTION_EMPH = "rcp_gtalk.actions.emph";
    private static final String ACTION_PRON = "rcp_gtalk.actions.pron";
    private static final String ACTION_VOICE = "rcp_gtalk.actions.voice";
    private static final String ACTION_VOLUME = "rcp_gtalk.actions.volume";
    private static final String ACTION_RATE = "rcp_gtalk.actions.rate";
    private static final String ACTION_PITCH_LEVEL = "rcp_gtalk.actions.pitch_level";
    private static final String ACTION_PITCH_RANGE = "rcp_gtalk.actions.pitch_range";
    private static final String ACTION_CONTEXT = "rcp_gtalk.actions.context";
    private static final String ACTION_SPELL = "rcp_gtalk.actions.spell";
    private IWorkbenchWindow window;
    private List tagList = new ArrayList();
    private Gtalk gtalk;

    public GtalkTagAction() {
        this.tagList.add(new Tag(ACTION_SILENCE, "SILENCE", true, "MSEC=\"1000\""));
        this.tagList.add(new Tag(ACTION_EMPH, "EMPH", false, ""));
        this.tagList.add(new Tag(ACTION_PRON, "PRON", false, "SYM=\"\u30aa\u30ad\u30ab\u30a8\u2019\u30c6\u30cd\""));
        this.tagList.add(new Tag(ACTION_VOICE, "VOICE", false, "OPTIONAL=\"female01\""));
        this.tagList.add(new Tag(ACTION_VOLUME, "VOLUME", false, "LEVEL=\"2\""));
        this.tagList.add(new Tag(ACTION_RATE, "RATE", false, "SPEED=\"2.0\""));
        this.tagList.add(new Tag(ACTION_PITCH_LEVEL, "PITCH", false, "LEVEL=\"1.5\""));
        this.tagList.add(new Tag(ACTION_PITCH_RANGE, "PITCH", false, "RANGE=\"1.5\""));
        this.tagList.add(new Tag(ACTION_CONTEXT, "CONTEXT", false, "TYPE=\"NUMBER\""));
        this.tagList.add(new Tag(ACTION_SPELL, "SPELL", false, ""));
    }

    public void run(IAction action) {
        GtalkView gtalkView = (GtalkView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(GtalkView.ID_VIEW);
        Tag[] tags = this.tagList.toArray(new Tag[this.tagList.size()]);
        int i = 0;
        while (i < tags.length) {
            if (action.getId().equals(tags[i].getKey())) {
                Point pt = gtalkView.getInputArea().getSelection();
                System.out.println(pt);
                String selection = gtalkView.getInputArea().getSelectionText();
                String preText = gtalkView.getInputArea().getText(0, pt.x - 1);
                String endText = gtalkView.getInputArea().getText(pt.y, gtalkView.getInputArea().getText().length());
                if (selection.length() > 0) {
                    if (tags[i].isSingle()) break;
                    gtalkView.getInputArea().setText(String.valueOf(preText) + "<" + tags[i].getName() + this.toAttribute(tags[i].getAttribute()) + ">" + selection + "</" + tags[i].getName() + ">" + endText);
                    break;
                }
                if (!tags[i].isSingle()) break;
                gtalkView.getInputArea().setText(String.valueOf(preText) + "<" + tags[i].getName() + this.toAttribute(tags[i].getAttribute()) + "/>" + endText);
                break;
            }
            ++i;
        }
    }

    private String toAttribute(String attribute) {
        if (attribute.length() > 0) {
            return " " + attribute;
        }
        return "";
    }

    private String fixText(String text) {
        String result = text.replaceAll("\n", "");
        result = result.replaceAll("\r", "");
        return result;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
        this.view = view;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public class Tag {
        private String key;
        private String name;
        private boolean single;
        private String attribute;

        public Tag(String key, String name, boolean single, String attribute) {
            this.key = key;
            this.name = name;
            this.single = single;
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isSingle() {
            return this.single;
        }

        public void setSingle(boolean single) {
            this.single = single;
        }
    }

    public class GtalkPlayer
    extends Thread {
        private String gtalkText;

        public GtalkPlayer(String text) {
            this.gtalkText = text;
        }

        public void run() {
            try {
                GtalkTagAction.this.gtalk.play(this.gtalkText);
            }
            catch (IOException e) {
                Gtalk.log.warn((Object)e);
            }
        }
    }
}

