/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech.views;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.part.ViewPart;
import org.jpn.xucker.rcp.jpspeech.JPSpeechPlugin;
import org.jpn.xucker.rcp.speech.SpeechPlugin;
import org.jpn.xucker.speech.multi.GtalkMbrolaJPPlayer;
import org.jpn.xucker.speech.multi.LineSplitter;
import org.jpn.xucker.speech.multi.USJPSplitter;

public class JapaneseVoiceSettingView
extends ViewPart {
    public static JapaneseVoiceSettingView defaultView;
    public static final String PITCH = "pitch";
    public static final String PITCH_RANGE = "pitch_range";
    public static final String DURATION = "duration";
    public static final String VIEW_ID;
    public static Log log;
    private GtalkMbrolaJPPlayer gtalkMbrolaJPPlayer;
    private Button ipadic;
    private Button readUs;
    private Scale durationStretchScale;
    private Scale pitchShiftScale;
    private Scale rateScale;
    private Scale pitchScale;
    private Scale pitchRangeScale;
    private Label stretchLabel;
    private Label pitchLabel;
    private Label pitchRangeLabel;
    private String voiceName = "male01";
    private float pitchValue;
    private float pitchRangeValue;
    private float durationStretchValue;
    private Label label1;
    private Label label2;
    private Label label3;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.speech.views.JapaneseVoiceSettingView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VIEW_ID = clazz.getName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jpn.xucker.rcp.speech.views.JapaneseVoiceSettingView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz2);
    }

    public boolean isReadUs() {
        return this.readUs.getSelection();
    }

    public JapaneseVoiceSettingView() {
        defaultView = this;
    }

    public static JapaneseVoiceSettingView getDefaultView() {
        return defaultView;
    }

    public void dispose() {
        if (!this.voiceName.equals("mbrola_jp3")) {
            this.updateValues(this.voiceName, this.pitchValue, this.durationStretchValue, this.pitchRangeValue);
        }
        super.dispose();
    }

    public String getGtalkHeaderTag() {
        String ret = "";
        String pitchAttribute = null;
        if ((double)this.pitchValue != 1.0) {
            pitchAttribute = "<PITCH LEVEL=\"" + this.pitchValue + "\"";
        }
        if ((double)this.pitchRangeValue != 1.0) {
            pitchAttribute = pitchAttribute == null ? "<PITCH RANGE=\"" + this.pitchRangeValue + "\"" : String.valueOf(pitchAttribute) + " RANGE=\"" + this.pitchRangeValue + "\"";
        }
        if (pitchAttribute != null) {
            ret = String.valueOf(pitchAttribute) + ">";
        }
        if ((double)this.durationStretchValue != 1.0) {
            ret = String.valueOf(ret) + "<RATE SPEED=\"" + this.durationStretchValue + "\">";
        }
        return ret;
    }

    public String getGtalkFooterTag() {
        String ret = "";
        String pitchAttribute = null;
        if ((double)this.durationStretchValue != 1.0) {
            ret = "</RATE>";
        }
        if ((double)this.pitchValue != 1.0) {
            pitchAttribute = "</PITCH>";
        }
        if ((double)this.pitchRangeValue != 1.0) {
            pitchAttribute = "</PITCH>";
        }
        if (pitchAttribute != null) {
            ret = String.valueOf(ret) + pitchAttribute;
        }
        return ret;
    }

    public void createPartControl(Composite master) {
        VoiceChanger changer = new VoiceChanger();
        master.setLayout((Layout)new GridLayout(4, true));
        Button voice1 = new Button(master, 16);
        voice1.setText("male01");
        voice1.addSelectionListener((SelectionListener)changer);
        Button voice2 = new Button(master, 16);
        voice2.setText("male02");
        voice2.addSelectionListener((SelectionListener)changer);
        Button voice3 = new Button(master, 16);
        voice3.setText("female01");
        voice3.addSelectionListener((SelectionListener)changer);
        try {
            JPSpeechPlugin.getDefault();
            Button voice4 = new Button(master, 16);
            voice4.setText("mbrola_jp3");
            voice4.addSelectionListener((SelectionListener)changer);
        }
        catch (Error error) {
            log.info((Object)"jpspeech not found");
        }
        voice1.setSelection(true);
        this.ipadic = new Button(master, 32);
        this.ipadic.setText(SpeechPlugin.getResourceString("use_ipadic"));
        this.ipadic.setToolTipText(SpeechPlugin.getResourceString("use_ipadic_tooltip"));
        this.ipadic.setSelection(true);
        this.ipadic.addSelectionListener((SelectionListener)new DicChanger());
        GridData data1 = new GridData();
        data1.horizontalSpan = 2;
        this.ipadic.setLayoutData((Object)data1);
        this.readUs = new Button(master, 32);
        this.readUs.setText(SpeechPlugin.getResourceString("read_US"));
        this.readUs.setToolTipText(SpeechPlugin.getResourceString("read_US_tooltip"));
        this.readUs.setSelection(false);
        this.readUs.addSelectionListener((SelectionListener)new ReadChanger());
        GridData data2 = new GridData();
        data2.horizontalSpan = 2;
        this.readUs.setLayoutData((Object)data2);
        ValueChangeMonitor monitor = new ValueChangeMonitor();
        Composite gp = new Composite(master, 0);
        this.label1 = new Label(gp, 0);
        this.label1.setText(SpeechPlugin.getResourceString("stretch"));
        this.toGridLayout(this.label1, 40);
        gp.setLayout((Layout)new GridLayout(3, false));
        this.stretchLabel = new Label(gp, 0x1000000);
        this.toGridLayout(this.stretchLabel, 30);
        GridData gpData1 = new GridData(768);
        gpData1.horizontalSpan = 2;
        gp.setLayoutData((Object)gpData1);
        this.durationStretchScale = new Scale(gp, 256);
        this.durationStretchScale.setMinimum(1);
        this.durationStretchScale.setMaximum(80);
        this.durationStretchScale.addSelectionListener((SelectionListener)monitor);
        this.durationStretchScale.setLayoutData((Object)new GridData(1808));
        Composite gp3 = new Composite(master, 0);
        this.label2 = new Label(gp3, 0);
        this.label2.setText(SpeechPlugin.getResourceString(PITCH));
        this.toGridLayout(this.label2, 40);
        gp3.setLayout((Layout)new GridLayout(3, false));
        GridData gpData3 = new GridData(768);
        gpData3.horizontalSpan = 2;
        gp3.setLayoutData((Object)gpData3);
        this.pitchLabel = new Label(gp3, 0x1000000);
        this.toGridLayout(this.pitchLabel, 30);
        this.pitchScale = new Scale(gp3, 256);
        this.pitchScale.setMinimum(1);
        this.pitchScale.setMaximum(100);
        this.pitchScale.addSelectionListener((SelectionListener)monitor);
        this.pitchScale.setLayoutData((Object)new GridData(1808));
        Composite gp4 = new Composite(master, 0);
        this.label3 = new Label(gp4, 0);
        this.label3.setText(SpeechPlugin.getResourceString(PITCH_RANGE));
        this.toGridLayout(this.label3, 40);
        gp4.setLayout((Layout)new GridLayout(3, false));
        GridData gpData4 = new GridData(768);
        gpData4.horizontalSpan = 2;
        gp4.setLayoutData((Object)gpData4);
        this.pitchRangeLabel = new Label(gp4, 0x1000000);
        this.toGridLayout(this.pitchRangeLabel, 30);
        this.pitchRangeScale = new Scale(gp4, 256);
        this.pitchRangeScale.setMinimum(1);
        this.pitchRangeScale.setMaximum(80);
        this.pitchRangeScale.addSelectionListener((SelectionListener)monitor);
        this.pitchRangeScale.setLayoutData((Object)new GridData(1808));
        this.initSpeechValue();
    }

    private void toGridLayout(Label label, int width) {
        GridData data = new GridData(768);
        data.widthHint = width;
        label.setLayoutData((Object)data);
    }

    public void setFocus() {
    }

    public GtalkMbrolaJPPlayer getGtalkMbrolaJPPlayer() {
        return this.gtalkMbrolaJPPlayer;
    }

    public void setGtalkMbrolaJPPlayer(GtalkMbrolaJPPlayer gtalkMbrolaJPPlayer) {
        this.gtalkMbrolaJPPlayer = gtalkMbrolaJPPlayer;
    }

    public void initSpeechValue() {
        if (this.gtalkMbrolaJPPlayer != null) {
            this.voiceName = this.gtalkMbrolaJPPlayer.getVoice();
        }
        float pitch = SpeechPlugin.getDefault().getPluginPreferences().getFloat(String.valueOf(this.voiceName) + "." + PITCH);
        float duration = SpeechPlugin.getDefault().getPluginPreferences().getFloat(String.valueOf(this.voiceName) + "." + DURATION);
        float pitchRange = SpeechPlugin.getDefault().getPluginPreferences().getFloat(String.valueOf(this.voiceName) + "." + PITCH_RANGE);
        this.updateLabels(pitch, duration, pitchRange);
        this.updateScale(pitch, duration, pitchRange);
    }

    public void updateScale(float pitch, float duration, float pitchRange) {
        this.pitchScale.setSelection((int)pitch * 10);
        this.pitchRangeScale.setSelection((int)pitchRange * 10);
        this.durationStretchScale.setSelection((int)duration * 10);
    }

    public void updateValues(String voiceName, float pitch, float duration, float pitchRange) {
        SpeechPlugin.getDefault().getPluginPreferences().setValue(String.valueOf(voiceName) + "." + DURATION, duration);
        SpeechPlugin.getDefault().getPluginPreferences().setValue(String.valueOf(voiceName) + "." + PITCH_RANGE, pitchRange);
        SpeechPlugin.getDefault().getPluginPreferences().setValue(String.valueOf(voiceName) + "." + PITCH, pitch);
    }

    public void updateLabels(float pitch, float duration, float pitchRange) {
        this.pitchValue = pitch;
        this.pitchRangeValue = pitchRange;
        this.durationStretchValue = duration;
        this.pitchLabel.setText("" + pitch);
        this.stretchLabel.setText("" + duration);
        this.pitchRangeLabel.setText("" + pitchRange);
    }

    public float getDurationStrech() {
        return (float)this.durationStretchScale.getSelection() / 10.0f;
    }

    public float getPitchShift() {
        return (float)this.pitchShiftScale.getSelection() / 10.0f;
    }

    public float getRate() {
        return this.rateScale.getSelection();
    }

    public float getPitch() {
        return (float)this.pitchScale.getSelection() / 10.0f;
    }

    public float getPitchRange() {
        return (float)this.pitchRangeScale.getSelection() / 10.0f;
    }

    public void setDefaultValue() {
        if (this.gtalkMbrolaJPPlayer != null) {
            this.voiceName = this.gtalkMbrolaJPPlayer.getVoice();
        }
        float pitch = SpeechPlugin.getDefault().getPluginPreferences().getDefaultFloat(String.valueOf(this.voiceName) + "." + PITCH);
        float duration = SpeechPlugin.getDefault().getPluginPreferences().getDefaultFloat(String.valueOf(this.voiceName) + "." + DURATION);
        float pitchRange = SpeechPlugin.getDefault().getPluginPreferences().getDefaultFloat(String.valueOf(this.voiceName) + "." + PITCH_RANGE);
        this.updateLabels(pitch, duration, pitchRange);
        this.updateScale(pitch, duration, pitchRange);
    }

    public class VoiceChanger
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            log.trace((Object)e.widget);
            if (e.widget instanceof Button) {
                String voiceName = JapaneseVoiceSettingView.this.gtalkMbrolaJPPlayer.getVoice();
                if (!voiceName.equals("mbrola_jp3")) {
                    JapaneseVoiceSettingView.this.updateValues(voiceName, JapaneseVoiceSettingView.this.getPitch(), JapaneseVoiceSettingView.this.getDurationStrech(), JapaneseVoiceSettingView.this.getPitchRange());
                }
                JapaneseVoiceSettingView.this.gtalkMbrolaJPPlayer.setVoice(((Button)e.widget).getText());
                if (((Button)e.widget).getText().equals("mbrola_jp3")) {
                    JapaneseVoiceSettingView.this.ipadic.setEnabled(false);
                    JapaneseVoiceSettingView.this.readUs.setEnabled(false);
                    JapaneseVoiceSettingView.this.label1.setEnabled(false);
                    JapaneseVoiceSettingView.this.label2.setEnabled(false);
                    JapaneseVoiceSettingView.this.label3.setEnabled(false);
                    JapaneseVoiceSettingView.this.pitchLabel.setEnabled(false);
                    JapaneseVoiceSettingView.this.pitchRangeLabel.setEnabled(false);
                    JapaneseVoiceSettingView.this.stretchLabel.setEnabled(false);
                    JapaneseVoiceSettingView.this.pitchScale.setEnabled(false);
                    JapaneseVoiceSettingView.this.pitchRangeScale.setEnabled(false);
                    JapaneseVoiceSettingView.this.durationStretchScale.setEnabled(false);
                } else {
                    JapaneseVoiceSettingView.this.pitchLabel.setEnabled(true);
                    JapaneseVoiceSettingView.this.pitchRangeLabel.setEnabled(true);
                    JapaneseVoiceSettingView.this.stretchLabel.setEnabled(true);
                    JapaneseVoiceSettingView.this.label1.setEnabled(true);
                    JapaneseVoiceSettingView.this.label2.setEnabled(true);
                    JapaneseVoiceSettingView.this.label3.setEnabled(true);
                    JapaneseVoiceSettingView.this.pitchScale.setEnabled(true);
                    JapaneseVoiceSettingView.this.pitchRangeScale.setEnabled(true);
                    JapaneseVoiceSettingView.this.durationStretchScale.setEnabled(true);
                    JapaneseVoiceSettingView.this.ipadic.setEnabled(true);
                    JapaneseVoiceSettingView.this.readUs.setEnabled(true);
                    JapaneseVoiceSettingView.this.initSpeechValue();
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class DicChanger
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                JapaneseVoiceSettingView.this.gtalkMbrolaJPPlayer.setUseIpadic(((Button)e.widget).getSelection());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ReadChanger
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                JapaneseVoiceSettingView.this.gtalkMbrolaJPPlayer.getGtalkPlayer().setReadUS(((Button)e.widget).getSelection());
                if (SpeechPlugin.getDefault().getLanguageMode() == 2) {
                    if (JapaneseVoiceSettingView.this.isReadUs()) {
                        SpeechPlugin.getDefault().getSpeech().setSpliter(new USJPSplitter());
                    } else {
                        SpeechPlugin.getDefault().getSpeech().setSpliter(new LineSplitter("jp"));
                    }
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ValueChangeMonitor
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            float pitch = JapaneseVoiceSettingView.this.getPitch();
            float duration = JapaneseVoiceSettingView.this.getDurationStrech();
            float pitchRange = JapaneseVoiceSettingView.this.getPitchRange();
            JapaneseVoiceSettingView.this.updateLabels(pitch, duration, pitchRange);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

