/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech.wizards;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.jpn.xucker.rcp.speech.SpeechPlugin;
import org.jpn.xucker.rcp.speech.views.PlayTextView;
import org.jpn.xucker.rcp.speech.wizards.LineDelimiterChoose;
import org.jpn.xucker.rcp.speech.wizards.MultiOutputWizardDelimiterPage;
import org.jpn.xucker.rcp.speech.wizards.MultiOutputWizardDirectoryPage;
import org.jpn.xucker.rcp.speech.wizards.MultiOutputWizardFileNamePage;
import org.jpn.xucker.rcp.ui.FileOverwriteControler;

public class MultiOutput
extends Wizard
implements INewWizard {
    private MultiOutputWizardDelimiterPage page;
    private MultiOutputWizardFileNamePage page2;
    private MultiOutputWizardDirectoryPage page3;
    private ISelection selection;
    public static MultiOutput current;
    private String text;

    public String getExtension() {
        return "." + this.page3.getCurrentExtension();
    }

    public String getLineDelimiter() {
        return this.page.getLineDelimiter();
    }

    public String[] getFileNames(String[] texts) {
        return this.page2.getFileNames(texts);
    }

    public String getOutputDir() {
        return this.page3.getOutputDir();
    }

    public void updateTable() {
        this.page.updateTable();
        this.page2.updateTable();
        this.page3.updateTable();
    }

    public MultiOutput() {
        this.setNeedsProgressMonitor(true);
        current = this;
    }

    public void addPages() {
        this.page = new MultiOutputWizardDelimiterPage(this.selection);
        this.addPage((IWizardPage)this.page);
        this.page2 = new MultiOutputWizardFileNamePage(this.selection);
        this.addPage((IWizardPage)this.page2);
        this.page3 = new MultiOutputWizardDirectoryPage(this.selection);
        this.addPage((IWizardPage)this.page3);
    }

    public boolean performFinish() {
        FileOverwriteControler controler = new FileOverwriteControler(this.getShell());
        String[] texts = LineDelimiterChoose.split(current.getText(), current.getLineDelimiter());
        String[] fileNames = current.getFileNames(texts);
        File dir = new File(current.getOutputDir());
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<String> textList = new ArrayList<String>();
        int i = 0;
        while (i < fileNames.length) {
            File tmp = new File(dir, fileNames[i]);
            boolean add = controler.canOverwrite(tmp);
            if (add) {
                fileList.add(tmp);
                textList.add(texts[i]);
            }
            if (controler.isCanceled()) break;
            ++i;
        }
        if (controler.isCanceled()) {
            return false;
        }
        try {
            SpeechPlugin.getDefault().getSpeech().write(fileList.toArray(new File[fileList.size()]), textList.toArray(new String[textList.size()]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean canFinish() {
        return this.page3.getOutputDir().length() > 0 && this.text.length() > 0;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        PlayTextView playTextView = (PlayTextView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(PlayTextView.VIEW_ID);
        this.text = playTextView.getText();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

