/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech.wizards;

import java.io.File;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jpn.xucker.rcp.speech.AudioFileUtils;
import org.jpn.xucker.rcp.speech.SpeechPlugin;
import org.jpn.xucker.rcp.speech.wizards.ExportTable;
import org.jpn.xucker.rcp.speech.wizards.LineDelimiterChoose;
import org.jpn.xucker.rcp.speech.wizards.MultiOutput;
import org.jpn.xucker.rcp.ui.FileDirChoicer;
import org.jpn.xucker.rcp.ui.FileStatusChangeEvent;
import org.jpn.xucker.rcp.ui.FileStatusChangeListener;

public class MultiOutputWizardDirectoryPage
extends WizardPage
implements FileStatusChangeListener {
    private ISelection selection;
    private Table table;
    private FileDirChoicer choicer;
    private String currentExtension;
    private CCombo fileTypeCombo;

    public MultiOutputWizardDirectoryPage(ISelection selection) {
        super(SpeechPlugin.getResourceString("splitexport"));
        this.setTitle(SpeechPlugin.getResourceString("choose_directory"));
        this.setDescription(SpeechPlugin.getResourceString("choose_export_directory"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        File path;
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, true));
        Label exportFileLabel = new Label(composite, 0);
        exportFileLabel.setText(SpeechPlugin.getResourceString("export_file_format"));
        String[] fileLabels = AudioFileUtils.createFileDialogName();
        this.fileTypeCombo = new CCombo(composite, 8);
        int i = 0;
        while (i < fileLabels.length - 2) {
            this.fileTypeCombo.add(fileLabels[i]);
            ++i;
        }
        this.fileTypeCombo.select(0);
        this.extensionChanged();
        this.fileTypeCombo.addSelectionListener((SelectionListener)new ExtensionChange());
        this.choicer = new FileDirChoicer(composite, 0, 1, SpeechPlugin.getResourceString("export_dir"));
        this.choicer.getLabelLayoutData().widthHint = 100;
        String defaultPath = SpeechPlugin.getDefault().getPreferenceStore().getString("export.directory");
        if (defaultPath.length() > 0 && (path = new File(defaultPath)).exists() && path.isDirectory()) {
            this.choicer.setFile(path);
        }
        this.choicer.setLayoutData((Object)new GridData(768));
        this.choicer.addFileListChangeListener((FileStatusChangeListener)this);
        Label label = new Label(composite, 0);
        label.setText(SpeechPlugin.getResourceString("preview"));
        this.createTable(composite);
        this.initialize();
    }

    public void extensionChanged() {
        this.currentExtension = AudioFileUtils.getExtensionByFileDialogName(this.fileTypeCombo.getItem(this.fileTypeCombo.getSelectionIndex()));
        MultiOutput.current.updateTable();
    }

    private void createTable(Composite composite) {
        GridData gridData8 = new GridData();
        this.table = new ExportTable(composite, 0).getTable();
        gridData8.horizontalSpan = 3;
        gridData8.horizontalAlignment = 4;
        gridData8.verticalAlignment = 4;
        gridData8.heightHint = 200;
        this.table.setLayoutData((Object)gridData8);
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateTable();
    }

    public void updateTable() {
        String[] texts = LineDelimiterChoose.split(MultiOutput.current.getText(), MultiOutput.current.getLineDelimiter());
        String[] fileNames = MultiOutput.current.getFileNames(texts);
        this.setTable(fileNames, texts);
    }

    public void setTable(String[] fileName, String[] text) {
        if (this.table != null) {
            this.table.removeAll();
            int i = 0;
            while (i < text.length) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(new String[]{fileName[i], text[i]});
                ++i;
            }
        }
    }

    private void initialize() {
        this.updateTable();
    }

    public String getOutputDir() {
        if (this.choicer == null) {
            return "";
        }
        return this.choicer.getAbsoluteFilePath();
    }

    public void removeList(FileStatusChangeEvent event) {
    }

    public void addList(FileStatusChangeEvent event) {
        this.setPageComplete(true);
    }

    public String getCurrentExtension() {
        return this.currentExtension;
    }

    public void setCurrentExtension(String currentExtension) {
        this.currentExtension = currentExtension;
    }

    public class ExtensionChange
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            MultiOutputWizardDirectoryPage.this.extensionChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

