/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sen.SenUtils;
import net.java.sen.StreamTagger;
import net.java.sen.Token;
import net.java.sen.processor.CompositPostProcessor;
import net.java.sen.processor.CompoundWordPostProcessor;
import net.java.sen.processor.PostProcessor;
import net.java.sen.processor.PreProcessor;
import net.java.sen.processor.RemarkPostProcessor;
import net.java.sen.processor.RemarkPreProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProcessorDemo {
    private static String compositRule = "";
    private static boolean isCompound = true;
    private static String compoundFile = null;
    private static String remarkRule = "";

    public static void main(String[] args) {
        try {
            Object processor;
            if (args.length != 2) {
                System.err.println("usage: java ProcessorDemo <\u30d5\u30a1\u30a4\u30eb\u540d> <\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0>");
                System.exit(1);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), args[1]));
            String confPath = System.getProperty("sen.home") + System.getProperty("file.separator") + "conf/sen-processor.xml";
            StreamTagger tagger = new StreamTagger((Reader)br, confPath);
            ProcessorDemo.readConfig(confPath);
            if (!isCompound) {
                CompoundWordPostProcessor cwProcessor = new CompoundWordPostProcessor(compoundFile);
                tagger.addPostProcessor(cwProcessor);
            }
            if (compositRule != null && !compositRule.equals("")) {
                processor = new CompositPostProcessor();
                ((CompositPostProcessor)processor).readRules(new BufferedReader(new StringReader(compositRule)));
                tagger.addPostProcessor((PostProcessor)processor);
            }
            if (remarkRule != null && !remarkRule.equals("")) {
                processor = new RemarkPreProcessor();
                ((RemarkPreProcessor)processor).readRules(new BufferedReader(new StringReader(remarkRule)));
                tagger.addPreProcessor((PreProcessor)processor);
                RemarkPostProcessor p2 = new RemarkPostProcessor();
                tagger.addPostProcessor(p2);
            }
            while (tagger.hasNext()) {
                Token token = tagger.next();
                System.out.println(token.getSurface() + "\t" + token.getPos() + "\t" + token.start() + "\t" + token.end() + "\t" + token.getCost() + "\t" + token.getAddInfo());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readConfig(String confFile) {
        block13: {
            String parent = new File(confFile).getParentFile().getParent();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new InputSource(confFile));
                NodeList nl = doc.getFirstChild().getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node n = nl.item(i);
                    if (n.getNodeType() != 1) continue;
                    String nn = n.getNodeName();
                    String value = n.getFirstChild().getNodeValue();
                    if (nn.equals("composit")) {
                        compositRule = compositRule + value + "\n";
                    }
                    if (nn.equals("compound") && value.equals("\u69cb\u6210\u8a9e")) {
                        isCompound = false;
                    }
                    if (nn.equals("remark")) {
                        remarkRule = remarkRule + value + "\n";
                    }
                    if (!nn.equals("dictionary")) continue;
                    NodeList dnl = n.getChildNodes();
                    for (int j = 0; j < dnl.getLength(); ++j) {
                        Node dn = dnl.item(j);
                        if (dn.getNodeType() != 1) continue;
                        String dnn = dn.getNodeName();
                        if (dn.getFirstChild() == null) {
                            throw new IllegalArgumentException("element '" + dnn + "' is empty");
                        }
                        String dvalue = dn.getFirstChild().getNodeValue();
                        if (!dnn.equals("compound")) continue;
                        compoundFile = SenUtils.getPath(dvalue, parent);
                    }
                }
                if (isCompound) break block13;
                try {
                    ObjectInputStream is = new ObjectInputStream(new FileInputStream(compoundFile));
                    HashMap hashmap = (HashMap)is.readObject();
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (ParserConfigurationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            catch (SAXException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }
}

